#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

#########################################################################
# winmmucl - Mark's MUd Client with a text widget to display output.
#
# Copyright (C) 1997 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#########################################################################

# Edit the below paths or let make do it. 
# Do NOT edit anything else unless you know tcl/tk.
# Do NOT delete any of the preceding lines. Make depends on them.
set Mmucl(lib_dir) ..
set Mmucl(rc_dir) ..
###########################

# Make sure the paths are absolute
if {[file pathtype Mmucl(lib_dir)]=="relative"} {
    set Mmucl(lib_dir) [file join [pwd] $Mmucl(lib_dir)]
}
if {[file pathtype $Mmucl(rc_dir)]=="relative"} {
    set Mmucl(rc_dir) [file join [pwd] $Mmucl(rc_dir)]
}

# Make the package mechanism look in the right place
set auto_path [linsert $auto_path 0 $Mmucl(lib_dir)]

package require mmucl
package require form

# toggle ansi on and off in display
proc ansi {} {
    global Mmucl

    if {$Mmucl(ansi)} {
	set Mmucl(ansi) 0
	echo "** Ansi color turned off. **"
    } else {
	set Mmucl(ansi) 1
	echo "** Ansi color turned on. **"
    }

}

# Maybe it would be nice to give echo have a color option.
proc echo {str} {
    .mudwin configure -state normal
 
    .mudwin insert end $str\n
    .mudwin yview end  
    
    if {[.mudwin index end]>300} {
	.mudwin delete 0.0 50.0
    }
    .mudwin configure -state disabled
}

# ansi color support
# Split $str into a list.Each element of the list will be
# ansi codes then plain text.
# Then I have to do some messy checking to make sure colors 
# are switched correctly as fg, bg, etc change color.or style
# If you know a better way to do this tell me. =)
proc display {str} {
    global Mmucl
   .mudwin configure -state normal
    if {$Mmucl(ansi)} {
	set b ""
	foreach part [split \[37\;40m$str ] {
	    regexp {\[([0-9;]+)m(.*)} $part x tags text
	    foreach tag [split $tags \;] {
		if {$tag<2} {
		    set b $tag
		} elseif {$tag<38} {
		    set fg $tag
		} else {
		    set bg $tag
		}
	    }
	    .mudwin insert end $text "$fg $bg $b" 
	}
    } else {
	.mudwin insert end $str\n
    }    
    .mudwin see end  
    if {[.mudwin index end]>300} {
	.mudwin delete 0.0 50.0
    }
    .mudwin configure -state disabled
}
  
# Make a menu

frame .menu -relief raised -borderwidth 1
menubutton .menu.file -text "File" -menu .menu.file.m 
menu .menu.file.m -tearoff 0 

.menu.file.m add command -label "Connect" -command Mgui_connect
.menu.file.m add command -label "Load File" \
    -command {tkOpen "Load a file" source}
.menu.file.m add command -label "Save" \
    -command {tkSave "Save Current Aliases and Actions" save}
.menu.file.m add command -label "Exit" -command \
    {tkDialog Mmucl "Really Quit?" exit}

menubutton .menu.help -text "Help" -menu .menu.help.m
menu  .menu.help.m -tearoff 0

.menu.help.m add command -label "About" -command {help about}
.menu.help.m add command -label "Contents" -command help

menubutton .menu.edit -text "Edit" -menu .menu.edit.m 
menu .menu.edit.m -tearoff 0
.menu.edit.m add command -label "Edit Alias" -command {\
	formMenu alias {{Name Commands}} alias unalias}
.menu.edit.m add command -label "Edit Action" -command {\
	formMenu action {{Pattern Commands}} action unaction}
.menu.edit.m add command -label "Edit Character" -command \
    {formMenu character {{Character {Mud Name} {Mud Location}\
       {Mud Port} Login}} charadd chardelete}

pack .menu.file .menu.edit -side left
pack .menu.help -side right

entry .input -textvariable Mmucl(input) -background lightsteelblue \
    -selectbackground grey

text .mudwin -width 70 -height 30 -wrap word -selectbackground gray \
    -yscrollcommand {.vscroll set} -background black -foreground white

scrollbar .vscroll -orient vertical -command {.mudwin yview} 

# Try to get a fixed font
catch {.mudwin configure -font fixed}

# Make the toolbar .tools and load in some misc procs
source [file join $Mmucl(lib_dir) lib _mmucl]

grid .menu -row 0 -column 0 -columnspan 2 -sticky "ew"
grid .tools -row 1 -column 0  -sticky "ew" -pady 2
grid .mudwin -row 2 -column 0 -sticky "news"
grid .vscroll -row 2 -column 1 -sticky "ns"
grid .input -row 3 -column 0 -columnspan 1 -sticky "ew"
grid columnconfigure . 0 -weight 1
grid rowconfigure . 2 -weight 1
wm title . Winmucl

# Ansi color support:
.mudwin tag configure 0  -foreground grey -font [.mudwin cget -font]

# Make sure we don't die on the new font specification
# The size may be off and fixed may not exist depending on the platform.
catch {.mudwin tag configure 1 -font {fixed 12 bold}}

.mudwin tag configure 4  -underline 1 
#.mudwin tag configure 5 flashing text?
.mudwin tag configure 30 -foreground black
.mudwin tag configure 31 -foreground red
.mudwin tag configure 32 -foreground green3
.mudwin tag configure 33 -foreground yellow
.mudwin tag configure 34 -foreground blue
.mudwin tag configure 35 -foreground purple
.mudwin tag configure 36 -foreground cyan
.mudwin tag configure 37 -foreground gray
.mudwin tag configure 40 -background black
.mudwin tag configure 41 -background red
.mudwin tag configure 42 -background green3
.mudwin tag configure 43 -background yellow
.mudwin tag configure 44 -background blue
.mudwin tag configure 45 -background purple
.mudwin tag configure 46 -background cyan
.mudwin tag configure 47 -background gray

# keep 0 lower than everything else.
.mudwin tag lower 0
# Make sure we can see the selection.
.mudwin tag raise sel

set Mmucl(ansi) 0
.mudwin configure -state disabled