#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

#########################################################################
# xmmucl - Mark's MUd Client using a console for output.
#
# Copyright (C) 1997 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#########################################################################

# Edit the below paths or let make do it.
# Do NOT edit anything else unless you know tcl/tk.
# Do NOT delete any of the preceding lines. Make depends on them.
set Mmucl(lib_dir) ..
set Mmucl(rc_dir) ..
############################

# Make sure the paths are absolute
if {[file pathtype Mmucl(lib_dir)]=="relative"} {
    set Mmucl(lib_dir) [file join [pwd] $Mmucl(lib_dir)]
}
if {[file pathtype $Mmucl(rc_dir)]=="relative"} {
    set Mmucl(rc_dir) [file join [pwd] $Mmucl(rc_dir)]
}

# Make the package mechanism look in the right place
set auto_path [linsert $auto_path 0 $Mmucl(lib_dir)]

package require mmucl
package require form

# Mmucl call backs for display
proc display {str} {
    puts -nonewline stdout $str
    flush stdout
}

proc echo {str} {
    puts stdout $str
    flush stdout
}

entry .input -relief sunken -textvariable Mmucl(input) -width 60 \
    -background lightsteelblue 

# Load in toolbar .tools and misc routines.
source [file join $Mmucl(lib_dir) lib _mmucl]

pack .tools -side top -fill x
pack .input -side top -fill x
wm resizable . 1 0
wm title . Xmmucl

# Accept input from the console.
fileevent stdin readable {set Mmucl(input) [gets stdin];parse_input}
fconfigure stdin -blocking 0 -buffering line
