package provide balloon 0.99.6

##############################################################################
# balloon.tcl - simple balloon help system
#
# Copyright (C) 1997 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##############################################################################

# Add a balloon message to a widget. (Probably should be a button.)
proc balloon_add {w message} {
    bind $w <Enter> "after 500 balloon_draw $w \\\"$message\\\""
    bind $w <Leave> [list balloon_erase $w $message]
}

# Draw the balloon
proc balloon_draw {w message} {
    toplevel .balloon -borderwidth 1 -relief ridge -bg black
    wm overrideredirect .balloon 1
    label .balloon.l -text $message -bg #fffeca
    pack .balloon.l
    wm geometry .balloon +[expr {[winfo rootx $w]+[winfo width $w]/2}]+[expr {[winfo rooty $w]+[winfo height $w]}]
}

# Erase the balloon
proc balloon_erase {w message} {
    after cancel balloon_draw $w \"$message\"
    catch {destroy .balloon}
}
