package provide form 0.99.6

#############################################################################
# form.tcl - simple package for editing records stored in arrays.
#
# Copyright (C) 1997 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#############################################################################

# Forms are simple windows which display a single column of
# labels and entries. The information put in a form is meant to
# be stored as a list in an array. The first entry of the form
# is the index into the array.

# save_command and delete_command must be defined as
# appropriate to what is to be done with the form info
# An application using the form package should just call
# formMenu

# labels is a list of the labels to the entry widgets
# save_command is a call_back that's given a list of each 
# element of labels as an argument
proc form {name labels save_command} {
    
    if {[winfo exists .$name]} {
        raise .$name
        return
    }

    toplevel .$name
    wm title .$name $name

    set count 0
    frame .$name.f -relief groove -bd 2
    foreach label $labels {
        grid [label .$name.f.l$count -text $label] -sticky w -column 0
	grid [entry .$name.f.e$count] -row $count -column 1
        incr count
    }
    pack .$name.f 

    frame .$name.b -bd 2 -relief ridge
    pack [button .$name.b.save -text "Save" -command "\
            form_save $save_command $name;destroy .$name"] \
	[button .$name.b.exit -text "Cancel" -command "destroy .$name"] \
	-side left
    pack .$name.b
    
    wm geometry .$name +[winfo pointerx .]+[winfo pointery .]
    wm resizable .$name 0 0
}

# puts the elements of list in form name
proc form_put {name list} {
    set count 0
    foreach element $list {
        .$name.f.e$count delete 0 end  
        .$name.f.e$count insert 0 $element
        incr count
    }
}

# returns a list of the current values in name's entry widgets
proc form_get {name} {
    set number [expr {[llength [winfo children .$name.f]]/2}]

    for {set count 0} {$count < $number} {incr count} {
        lappend results [.$name.f.e$count get]
    }
    return $results
}

# save the record of form name  with a callback command.
proc form_save {command name} {   
    eval $command [form_get $name]
    formMenu_update $name
}

# delete a record of form name with the callback command.
# the delete command is given a index in the record's array
# to delete.
proc form_delete {command name} {
    set i [.fm$name.f.list curselection]
    if {$i!=""} {
	$command [.fm$name.f.list get $i]
	formMenu_update $name
    }
}

# fills the form with the active record
proc form_active {name} {
    global [set name]_array

    set i [.fm$name.f.list curselection]
    if {$i!=""} {
	set list "[list [.fm$name.f.list get $i]] \
                  [set [set name]_array([.fm$name.f.list get $i])]"
	form_put $name $list
    }
}

# updates the form menu to reflect the record array of name
proc formMenu_update {name} {
    global [set name]_array

    .fm$name.f.list delete 0 end
    foreach element [lsort [array names [set name]_array]] {
	.fm$name.f.list insert end $element
    }
}

# a menu of records of type name
proc formMenu {name labels save_command delete_command} {

    if {[winfo exists .fm$name]} {
	raise .fm$name
	return
    }
    
    toplevel .fm$name
    wm title .fm$name "Edit $name"
    
    frame .fm$name.f -relief ridge -bd 2
    pack [listbox .fm$name.f.list -yscroll ".fm$name.f.yscroll set" \
	      -selectmode single ] -side left
    pack [scrollbar .fm$name.f.yscroll -command ".fm$name.f.list yview"] \
	-side left -fill y
    
    frame .fm$name.b -relief ridge -bd 2
    pack [button .fm$name.b.edit -text "Edit" -command "\
	    form $name $labels $save_command;\
	    form_active $name"] -side left
    pack [button .fm$name.b.delete -text "Delete" -command \
	      [list form_delete $delete_command $name]] -side left
    pack [button .fm$name.b.exit -text "Exit" -command "\
	    catch {destroy .fm$name .$name}"] -side left
    
    pack .fm$name.f .fm$name.b

    formMenu_update $name
    bind .fm$name.f.list <Double-Button-1> "\
	     form $name $labels $save_command;\
	     form_active $name"

    wm geometry .fm$name +[winfo pointerx .]+[winfo pointery .]
    wm resizable .fm$name 0 0
}





