package provide html_browse 0.6

#########################################################################
# html_browse.tcl - Provides a very simple local html viewer
# using Stephen Uhler's html_library 0.3.

# Copyright (C) 1997 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#########################################################################


# uses the scroll history procedure that's defined in _mmucl
# history isn't really
proc HM_browse {file} {
    package require html
    global HM_browse

    if {[winfo exists .browse]} {
	HMreset_win .browse.display
	return
    }
    
    array set HM_browse "
	history {}
	histloc 0
	file $file
    "
    
    toplevel .browse
    
    frame .browse.t -relief ridge -bd 2
    pack [button .browse.t.back -text "Back" -command \
	      {HMlink_callback .browse.display [_scrollHistory \
	      HM_browse(history) HM_browse(histloc) 1] 0}] -side left
    pack [button .browse.t.forward -text "Forward" -command \
	      {HMlink_callback .browse.display [_scrollHistory \
              HM_browse(history) HM_browse(histloc) -1] 0}] \
	-side left -padx 5
    pack [entry .browse.t.file -textvariable HM_browse(file)] \
	[button .browse.t.load -text "Load" -command \
	     {HMlink_callback .browse.display $HM_browse(file)}] \
	-side left -padx 5
    pack [button .browse.t.exit -text "Exit" -command \
	      {HMreset_win .browse.display;destroy .browse;catch \
		   {unset HM_browse}}] -side right

    text .browse.display -width 60 -height 30\
	-yscrollcommand {.browse.vscroll set} -wrap word

    scrollbar .browse.vscroll -orient vertical -command \
	{.browse.display yview}
    
    grid .browse.t -sticky ew
    grid .browse.display -row 1 -sticky news
    grid .browse.vscroll -row 1 -column 1 -sticky ns
    grid columnconfigure .browse 0 -weight 1
    grid rowconfigure .browse 1 -weight 1
    
    bind .browse.t.file <Key-Return> \
	{HMlink_callback .browse.display $HM_browse(file)}
    
    HMinit_win .browse.display
    HMlink_callback .browse.display $file
    .browse.t.file xview end
}

proc HMlink_callback {win href {flag 1}} {  
    upvar \#0 HM_browse(file) file HM_browse(history) history\
	HM_browse(histloc) loc
    
    # Ignore out of range history from back and forward buttons.
    if {$href==""} {return}
    
    $win configure -state normal
    HMreset_win $win
    
    # Change href to file(updates entry) and make it absolute
    if {[file pathtype $href]=="relative"} {
	set file [file join [file dirname $file] $href]
    } else {
	set file $href
    }
    
    if {[catch {set fd [open $file]} msg]} {
        set html "
                        <title>Bad file $file</title>
                        <h3>Error reading $file</h3><p>
                        $msg<hr>
                "
    } else {
	set html [read $fd]
	close $fd
    }
    
    HMparse_html $html "HMrender $win"
    $win configure -state disabled

    # Only do history stuff if not called by the back or forward buttons.
    if {$flag} {
	set history [linsert $history $loc $file]
    }
}








