/*** Program Module Usage:

	To get a waiting DCC'd File:
		zdcc 0 host port filename filesize
	To send a DCC file
		zdcc 1 0 0 filename 0


***/



#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <fcntl.h>    




int init_server(int *port){
	struct hostent *zhost, chost;
        struct sockaddr_in addr;
        int sock, t;
        int hostaddr, hostptr[2];

	if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0)
    	{
       	 return -1;
    	}        


	hostaddr = INADDR_ANY;
	chost.h_addr_list = (char **) hostptr;
	chost.h_addr_list[0] = (char *) &hostaddr;
    	chost.h_addr_list[1] = NULL;
    	chost.h_length = sizeof(hostaddr);
    	chost.h_addrtype = AF_INET;
    	zhost = &chost;

    	bzero((char *) &addr, sizeof(addr));
    	addr.sin_family = AF_INET;
    	memcpy((char *) &(addr.sin_addr.s_addr),
           (char *) zhost->h_addr_list[0],
           (size_t) zhost->h_length);
    	addr.sin_port = htons(*port);                

	if (bind(sock, (struct sockaddr *) &addr, sizeof(addr)) < 0)
    	{
       	 (void) close(sock);
	 printf("XMSG:DCC Error: Unable to bind socket.\n");
	fflush(stdout);
       	 return -1;
    	}
    	t = sizeof(addr);
    	getsockname (sock, (struct sockaddr *) &addr, &t);
    	*port = ntohs(addr.sin_port);



       	printf("PORT:%d\n",*port);	
	fflush(stdout);
	printf("XMSG:Waiting for connection...\n"); 
	fflush(stdout);

    return sock;


}

int init_connection(int socki){

	struct sockaddr_in addr;
	int l=sizeof(addr);
	int sock;
	printf("XMSG:Initializing Server.\n");
	fflush(stdout);
	sock=accept(socki,(struct sockaddr *) &addr, &l);
	printf("XMSG:DCC Server Waiting...\n");
	fflush(stdout);
	shutdown(socki,2);
	close(socki);
	if(sock <0) { return -1;} 
	else { return sock;}
}

void send_file(int sock,char file[],char host[]){

	char buffer[4096];
	int i,f, len, totallen=0;
	struct timeval to;
	struct stat fl;
	time_t t;
	int numblocks;
	fd_set rdset;
	


	if((f=open(file, O_RDONLY)) <0){
		printf("XMSG:DCC Error: Unable to open %s",file);
		fflush(stdout);
	}else{


		fstat(f,&fl);
		numblocks=(fl.st_size/2048+1)/10;
		t=time((time_t *) 0);

		while((len=read(f,buffer,2048))>0) {

			totallen+=len;
			write(sock,buffer,len);
			printf("XTRN:%d\n",totallen);
			fflush(stdout);
			do{
				FD_ZERO(&rdset);
				FD_SET(sock, &rdset);
				to.tv_sec=10;
				to.tv_usec=0;
				if(select(sock+1,&rdset,NULL,NULL,&to)!=1){
					len=-1;
					break;
				}else{
					if(read(sock,(char *) &i,sizeof(int)) !=sizeof(int)){
						printf("XMSG:DCC Error: Cannot read from socket.\n");
						fflush(stdout);
						len=-1;
						break;
					}	
				}
			} while (ntohl(i) != totallen);

		}
	}
	shutdown(sock,2);
	close(sock);
	unlink(host);
	close(f);
	if (len >= 0){
                if ((t=time((time_t *) 0) -t)==0) {
                 t=1;
                }
                printf("XMSG:DCC send  completed.  %.0f Kbytes/sec\n",((float) totallen / 1000)/(float) t);
		fflush(stdout);
		printf("DONE");
		fflush(stdout);
        }

        exit(0);  
		
}

int accept_connection(char host[], int port) {

	struct hostent *zhost, chost;
	struct sockaddr_in addr;
	int sock, t;
	int hostaddr, hostptr[2];

	printf("XMSG:Connecting to %s,%d\n",host,port);
		fflush(stdout);

	if((zhost = gethostbyname(host)) == NULL)
	 {
		chost.h_addr_list=(char **) hostptr;
		chost.h_addr_list[0]= (char *) &hostaddr;
		chost.h_addr_list[1]=NULL;
		chost.h_length=sizeof(hostaddr);
		chost.h_addrtype=AF_INET;
		zhost=&chost;		
	}

	if (( sock=socket(PF_INET, SOCK_STREAM,0)) <0){return -1;}

	bzero((char *) &addr, sizeof(addr));
	addr.sin_family = AF_INET;
	memcpy((char *) &(addr.sin_addr.s_addr),
           (char *) zhost->h_addr_list[0],
           (size_t) zhost->h_length);
	addr.sin_port = htons(port);

	if (connect(sock, (struct sockaddr *) &addr, sizeof(addr)) < 0)
    	{
       	 close(sock);
       	 return -1;
    	}
    	return sock;         

}







void receive_file(int sock, char file[], int size,char host[]){
	char buffer[4096];
	time_t t;
	int len=-1;
	int totallen=0;
	int nettotal=0;
	int out;

	printf("XMSG:Receiving %s...\n",file);
	fflush(stdout);
	t=time((time_t *) 0);

	if((out=open(file, O_WRONLY | O_CREAT | O_TRUNC, 0600)) >= 0){
	
		while((len=read(sock,buffer,4096))!=0) {
			totallen+=len;
			printf("XTRN:%d\n",totallen);
			fflush(stdout);
			write(out,buffer,len);
			nettotal=htonl(totallen);
			write(sock,(char *) &nettotal,sizeof(int));

		}
	}
	close(out);
	shutdown(sock,2);
	close(sock);
	if (len <0){
		unlink(host);
	} else {
		if ((t=time((time_t *) 0) -t)==0) {
		 t=1;
		}
		printf("XMSG:DCC get of %s completed.  %.0f Kbytes/sec\n",file,((float) totallen / 1000)/(float) t);
		fflush(stdout);		
		printf("DONE");
		fflush(stdout);		
	}

	exit(0);
}
void dcc_get(char host[], int port, char file[], int size){

	int sock;

	sock=accept_connection(host, port);
	if(sock>0){
	receive_file(sock,file, size,host);	
	} else {
		printf("XMSG:DCC Error: Unable to open socket.\n");
		fflush(stdout);		
		exit(-1);
	}
	
}
void dcc_send(int port, char file[],char host[]){

	int socki,sock;
	printf("XMSG:Creating server socket.\n");
	fflush(stdout);
	socki=init_server(&port);
	if(socki== -1){printf("XMSG:DCC Error: Could not create server socket.\n");
		fflush(stdout);		
			exit (-1);
	}
	printf("XMSG:Waiting for Connection.\n");
	listen(socki,5);
	printf("XMSG:Creating transfer server.\n");
	fflush(stdout);
	sock=init_connection(socki);		
	if(sock== -1){printf("XMSG:DCC Error: Could not create socket.\n");
		fflush(stdout);		
			exit (-1);
	}
	printf("XMSG:Connection Established.\n");	
		fflush(stdout);		
	send_file(sock,file,host);

}


main(int argc, char *argv[]) {

	int type=atoi(argv[1]);
	int port=atoi(argv[3]);
	int size=atoi(argv[5]);


	if(type==0){
		dcc_get(argv[2], port, argv[4], size);
	} else {
		dcc_send(port, argv[4],argv[2]);
	}	
}
