#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

set f [open /tmp/zipperpath "r" ]
set  installpath [gets $f]
close $f

cd $installpath

exec "ridx" 
set auto_path "$auto_path $installpath"
package require ctcp 1
package require custom 1.0
package require server 1.0
package require user 1.0
package require personal 1.0
package require dccchat 1.0
package require winman 1.0
package require clicks 1.0
package require util 1.0
package require events 1.0
package require setup 1.0

set version 1.01a
set device "eth0"
set actwin ""
set xip ""
set esvrSock ""
set currchan ""
set response ""
set ctcp_message ""
set parm1 ""
set parm2 ""
set parm3 ""
set parm4 ""
set parm5 ""
set parm6 ""
set varlist ""
set userlist ""
set aliaslist ""
set eventlist ""
set notify ""
set longip ""
set serveractive 0
set ignore ""
set ctag "0"
set whoisvisible 1
set bansvisible 1
set whoisuser ""
set channels ""
set chef 0
set bytefloodlimit 350
set timerarray(00) "multi|0|0|"

#set default fonts
set serverfont   8x13
set channelfont  8x13
set queryfont    8x13

#set default event style
set kickst ""
set joinst ""
set notfst ""
set notcst ""
set actst  ""
set partst ""

set kickcol 4
set joincol 3
set notfcol 3
set notccol 7
set actcol  6
set partcol 3
set modecol 3

### Window Information Data structure
set chaninfo(server,type) "server"
set chaninfo(server,nickchan) "server"
set chaninfo(server,stat) "I"
set chaninfo(server,name) ".zipperserver"
set chaninfo(server,winnumber) "server"
set chaninfo(server,socket) "undefined"
set chaninfo(server,history) ""
set chaninfo(server,historyidx) 0
set chanrev(.zipperserver) "server"

set historyidx(server) 0
set history(server) ""

# flood detection settings example
# current message count
# start time of count
# number secs in time limit
# lines per timelimit 
# average lines per time limit

set flooddetect(userhost,count) 0
set flooddetect(userhost,start) 0
set flooddetectsecs 10
set flooddetectlimit 5
set flooddetect(userhost,avglpm) 0



set servers ""
set userpopups(notify) ""
set userpopups(userlist) ""
set userpopups(channel) ""
set userpopups(query) ""
set listmatch ""
set varlist ""
set loadscript ""
set defaultquit "Ok..Luv you...Byebye!"

set tmp [exec whoami]
set rcdir "[file dirname ~]/$tmp"
set rcdir "$rcdir/.zipper"

set allowsaverc 1

#
#       0 white       8 yellow
#       1 black       9 lightgreen
#       2 blue       10 cyan
#       3 green      11 lightcyan
#       4 red   12 lightblue
#       5 brown      13 pink
#       6 purple     14 grey
#       7 orange     15 lightgrey
#                       


array set mirccolors {
        0 #ffffff   8 #ffff00
        1 #000000   9 #8cff8c
        2 #0000ff   10 #00ffff
        3 #00ff00   11 #e0ffff
        4 #ff8c8c   12 #add8e6
        5 #a52a2a   13 #ffc0cb
        6 #a020f0   14 #bebebe
        7 #ffa500   15 #d3d3d3
}
                       



set rc [lindex $argv 0]
set sav [lindex $argv 1]
set netdev [lindex $argv 2]


if ![sNull $rc] {
	set rcdir $rc
}
if ![sNull $sav] {
	set allowsaverc $sav
}


init_check_rc
init_user_rc
init_ctcp_rec
init_events
init_aliases
init_notify
init_ignore
init_channels
init_servers
init_users
init_stylecolors
set_styles
#####
set winlist ""
set winbase 0
set myuserhost "$nick!$username@$hostname"

if ![sNull $netdev] {
	set device $netdev
}


wm withdraw .
set w server
new_server $w "Zipper: Not Connected"
notify_window

##### Calculate Coordinates

after 1000 processtimers
tkwait window .zipperserver
