# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please refer to the BSD type license enclosed in this package

set rcsId {$Id: datagraf.tcl,v 1.34 1998/05/01 15:16:21 jfontain Exp $}

class dataGraph {

if {$::officialBLT} {
    set (widget) stripchart
} else {
    set (widget) graph
}

    proc dataGraph {this parentPath args} composite {
        [new $dataGraph::(widget) $parentPath -title {} -topmargin 3 -bufferelements 0 -plotborderwidth 1] $args
    } blt2DViewer {$widget::($this,path)} {
        $widget::($this,path) xaxis configure -tickfont $font::(smallNormal) -title {} -rotate 90 -command dataGraph::axisTime
        composite::complete $this
    }

    proc ~dataGraph {this} {}

    proc iconData {} {
        return {
            R0lGODdhKAAoAKUAAHt5e87PzgAAANbX1v///zFhITFhGJTXa633e6X3e5znc6Xvc3u+Wpznazk4
            OZTfa4zPY3NJAPffSufHOda2Mc6mKVIIY2sYexBhe4wQpa3X54S+zr0o1qUYvbUYzrUg1lKWrb0Y
            3t44/60Yzt5B/+dJ/+dR/9YY984Y7+dZ/+dh/94o/+9x/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAKAAoAAAG/kCAcEgsGo/IYQAg
            aDqf0Kh02lwKAthsYIDlbrVer3Y8ZgYI6DQaoG6z2+n3Gm09wwlyeN6tflsHd3iBgoF5fmZDBYpJ
            AIoGBUaPj0Z1aAUHmAWEapeYB5ppBQgICQqghwKABJ2ZeYoLCwoLpYqKpbAMkISVqwyeC6CrsAoK
            DAzDCg3FC8aQbKhLQgW+BwsNtdUNzdMMxb7bDuFEf5zGyp4H2osOisbbAA5y0G3cD98QuUPxjbX6
            fXRMVHHi5s7ZHCNz4gC8gqTWIkYQAfCCs2/Iv0IXyd2JwJEjH4wKCUxMw1GCSZMRLt4xtDDakAgm
            J8iUKSGCkY42GY2EKZNC/oWfFCbUTAmg5EmPLEUGJCmhZ4WOFYKihNl05tSMZtDwnOAzZ9GfNJv6
            /BlVaM2Qf4REoMD2abi3HKOy7Qo1aNeKErMSiEDWpgM3fPsSCfzT5i69ezkK+Qu4oyGcQg5f6ROZ
            sZ54K/cltEKls2cpViyIvoCh9IXTqFOXNp2a9OrWF6xkmI1Bg20Ms3Pnrm1bA+7dvTdguMChOAcr
            HTx8wLChue8P0KGX1tDc+era1UEMDxFChAgrIzyMwACi+nPptpuDKL+hN/UN64dfCEGiPvgR0tm3
            X/0+Pnn98GknH3clFAgeByEg+J9z6cHHWmnr+Ycad/XZxwR3GIawYHUOXsJ23YQYmiCiCVZwhyCC
            Gv4X4YAYwjbiiyOWeAIKM6KAQgiuvXZBCjz26OOPQFpRo41E4phaBiGooOSSTDbppJAoOCnllFQ2
            acUKK7Cg5ZZcdunll18uQcaYZJZZZhAAOw==
        }
    }

    proc options {this} {
        # force size and interval values
        return [list\
            [list -height height Height 200]\
            [list -interval interval Interval 5]\
            [list -samples samples Samples 101 101]\
            [list -width width Width 300]\
        ]
    }

    foreach option {-height -width} {
        proc set$option {this value} "\$widget::(\$this,path) configure $option \$value"
    }

    proc set-interval {this value} {
        set range [expr {$composite::($this,-samples)*$value}]
        set size [expr {$range/10}]                                                   ;# do not display more than 10 major divisions
        # choose among predefined discrete values
        foreach step {60 300 600 1800 3600 18000 36000 86400} division {6 5 5 5 6 5 5 4} {
            if {$step>$size} break
        }
        $widget::($this,path) xaxis configure -stepsize $step -subdivisions $division
if {$::officialBLT} {
        $widget::($this,path) xaxis configure -range $range -shiftby $value
} else {
        xAxisUpdate $this [clock seconds]
}
    }

    proc set-samples {this value} {                                                                     ;# stored at composite level
        if {$composite::($this,complete)} {
            error {option -samples cannot be set dynamically}
        }
    }

if {!$::officialBLT} {
    proc xAxisUpdate {this currentTime} {
        $widget::($this,path) xaxis configure\
            -min [expr {$currentTime-($composite::($this,-samples)*$composite::($this,-interval))}] -max $currentTime
    }
}

    proc axisTime {path value} {
        return [clock format $value -format %H:%M]                                    ;# do not show seconds as they are always zero
    }

    proc newElement {this path args} {                                                          ;# invoked from 2D viewer base class
        return [eval new element $path $args]
    }

if {!$::officialBLT} {
    proc updateTimeDisplay {this seconds} {
        xAxisUpdate $this $seconds
    }
}

    proc updateElement {this element seconds value} {
        element::update $element $seconds $value
    }

}

class dataGraph {
    class element {

if {$::officialBLT} {
        set (scope) variable
} else {
        set (scope) global                           ;# prevents BLT internal error report on exit with at least one graph displayed
}

        proc element {this path args} switched {$args} {
            [set (scope)] ${this}xData
            [set (scope)] ${this}yData

            $path element create $this -label {} -symbol none                         ;# use object identifier as element identifier

            set dots [expr {$configuration::(graphNumberOfIntervals)+1}]
if {$::officialBLT} {
            blt::vector -variable ${this}xData ${this}xData($dots)                                             ;# x axis data vector
            blt::vector -variable ${this}yData ${this}yData($dots)                                             ;# y axis data vector
} else {
            blt::vector ${this}xData($dots)
            blt::vector ${this}yData($dots)
}
            $path element configure $this -xdata ${this}xData -ydata ${this}yData

            set ($this,path) $path
            switched::complete $this
        }

        proc ~element {this} {
            [set (scope)] ${this}xData
            [set (scope)] ${this}yData

            unset ${this}xData ${this}yData
            [set ($this,path)] element delete $this
            if {[string length $switched::($this,-deletecommand)]>0} {
                uplevel #0 $switched::($this,-deletecommand)                                ;# always invoke command at global level
            }
        }

        proc options {this} {
            return [list\
                [list -color black black]\
                [list -deletecommand {} {}]\
                [list -label {} {}]\
            ]
        }

        foreach option {-color -label} {
            proc set$option {this value} "\[set (\$this,path)\] element configure \$this $option \$value"
        }

        proc set-deletecommand {this value} {}                                                   ;# data is stored at switched level

        proc update {this x y} {
            [set (scope)] ${this}xData
            [set (scope)] ${this}yData

            if {[string length $y]==0} {
                set y 0                                                              ;# too bad BLT graph cannot handle empty values
            }
            ${this}xData delete 0                                                     ;# achieve scrolling by deleting first element
            ${this}yData delete 0
            ${this}xData append $x                                                                        ;# and appending new value
            ${this}yData append $y
        }
    }
}
