# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please refer to the BSD type license enclosed in this package

set rcsId {$Id: help.tcl,v 1.16 1998/05/01 20:06:11 jfontain Exp $}

namespace eval help {

    variable nameAndVersion {
moodss: a Modular Object Oriented Dynamic SpreadSheet
version 3.3
    }

    variable description {
Copyright (C) 1997-98 Jean-Luc Fontaine. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software must display the following acknowledgement:
        This product includes software developed by Jean-Luc Fontaine.
4. The name of the author may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

        jfontain@mygale.org


This software includes the Tcl HTML library developped by Sun Microsystems and made available under the following license terms:

Sun Microsystems, Inc.  The following terms apply to all files associated with the software unless explicitly disclaimed in individual files.

The authors hereby grant permission to use, copy, modify, distribute, and license this software and its documentation for any purpose, provided that existing copyright notices are retained in all copies and that this notice is included verbatim in any distributions. No written agreement, license, or royalty fee is required for any of the authorized uses. Modifications to this software may be copyrighted by their authors and need not follow the licensing terms described here, provided that the new terms are clearly indicated on the first page of each file where they apply.

IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

RESTRICTED RIGHTS: Use, duplication or disclosure by the government is subject to the restrictions as set forth in subparagraph (c) (1) (ii) of the Rights in Technical Data and Computer Software Clause as DFARS 252.227-7013 and FAR 52.227-19.
    }
}

proc simpleTextDialogBox {title text} {
    set dialog [new dialogBox . -buttons o -default o -title $title -x [winfo pointerx .] -y [winfo pointery .]]
    set widget [new scroll text $widget::($dialog,path)]
    $composite::($widget,scrolled,path) insert end $text
    $composite::($widget,scrolled,path) configure\
        -state disabled -borderwidth 0 -font $font::(mediumNormal) -wrap word -height 20 -padx 10
    bind $widget::($dialog,path) <Destroy> "catch {delete $widget}"                  ;# delete objects not managed by the dialog box
    dialogBox::display $dialog $widget::($widget,path)
}

proc aboutDialogBox {} {
    set dialog [new dialogBox . -buttons o -default o -title {moodss: about} -x [winfo pointerx .] -y [winfo pointery .]]
    set frame [frame $widget::($dialog,path).frame]
    set text [new scroll text $frame]
    $composite::($text,scrolled,path) insert end $help::description
    $composite::($text,scrolled,path) configure\
        -state disabled -borderwidth 0 -font $font::(mediumNormal) -wrap word -height 20 -padx 10

    grid rowconfigure $frame 1 -weight 1
    grid columnconfigure $frame 0 -weight 1
    grid columnconfigure $frame 1 -weight 1
    grid $widget::($text,path) -row 1 -column 0 -columnspan 2 -sticky nsew

    set TRANSPARENT_GIF_COLOR [$frame cget -background]
    grid [label $frame.icon -image [image create photo -data [dataGraph::iconData]]] -row 0 -column 0
    grid [label $frame.name -text $help::nameAndVersion] -row 0 -column 1

    bind $widget::($dialog,path) <Destroy> "catch {delete $text}"                    ;# delete objects not managed by the dialog box
    dialogBox::display $dialog $frame
}

proc modulesHelpDialogBox {args} {                                                                     ;# arguments are module names
    foreach module $args {
        append text "$module module:\n"
        if {[catch {append text [set ${module}::data(helpText)]}]} {
             append text "\nno help available\n"
        }
        append text \n
    }
    simpleTextDialogBox {moodss: modules help} $text
}
