source stooop.tcl
namespace import stooop::*

# expected output:
## cannot make static procedure f of class ::a virtual
## cannot make static procedure f of class ::A virtual
## cannot make static procedure f of class ::a::b virtual
## cannot make static procedure f of class ::A::B virtual

catch {
    class a {}
    virtual proc a::f {p} {}
} message
puts $message

catch {
    class A {
        virtual proc f {p} {}
    }
} message
puts $message

catch {
    class a {}
    proc a::a {this} {}
    class a::b {}
    virtual proc a::b::f {p} {}
} message
puts $message

catch {
    class A {
        proc A {this} {}
        class B {
            virtual proc f {p} {}
        }
    }
} message
puts $message


