source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1 x y {1 2} 3
## b::b 1 x y {1 2} 3
## a::(1,_derived) = ::b
## a::(1,m) = 1 2
## b::(1,n) = 1 2

## A::A 2 x y {1 2} 3
## B::B 2 x y {1 2} 3
## A::(2,_derived) = ::B
## A::(2,m) = 1 2
## B::(2,n) = 1 2

## d::d 3 x y {1 2} 3
## e::e 3 x y {1 2} 3
## c::d::(3,_derived) = ::c::e
## c::d::(3,m) = 1 2
## c::e::(3,n) = 1 2

## D::D 4 x y {1 2} 3
## E::E 4 x y {1 2} 3
## D::(4,_derived) = ::C::E
## D::(4,m) = 1 2
## E::(4,n) = 1 2
## D::D 5 x y {1 2} 3
## E::E 5 x y {1 2} 3
## C::D::(4,_derived) = ::C::E
## C::D::(4,m) = 1 2
## C::D::(5,_derived) = ::C::E
## C::D::(5,m) = 1 2
## C::E::(4,n) = 1 2
## C::E::(5,n) = 1 2

class a {}
proc a::a {this p args} {
    puts "a::a $this $p $args"
    set a::($this,m) [lindex $args 0]
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p args} a {$p $args} {
    puts "b::b $this $p $args"
    set b::($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}
new b {x y} {1 2} 3
printArrays a:: b::

class A {
    proc A {this p args} {
        puts "A::A $this $p $args"
        set A::($this,m) [lindex $args 0]
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p args} A {$p $args} {
        puts "B::B $this $p $args"
        set B::($this,n) [lindex $args 0]
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
new B {x y} {1 2} 3
printArrays A:: B::

class c {}
class c::d {}
proc c::d::d {this p args} {
    puts "d::d $this $p $args"
    set c::d::($this,m) [lindex $args 0]
}
proc c::d::~d {this} {
    puts "d::~d $this"
}
class c::e {}
proc c::e::e {this p args} c::d {$p $args} {
    puts "e::e $this $p $args"
    set c::e::($this,n) [lindex $args 0]
}
proc c::e::~e {this} {
    puts "e::~e $this"
}
new c::e {x y} {1 2} 3
printArrays c::d:: c::e::

class C {
    class D {
        proc D {this p args} {
            puts "D::D $this $p $args"
            set C::D::($this,m) [lindex $args 0]
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
    }
    class E {
        proc E {this p args} C::D {$p $args} {
            puts "E::E $this $p $args"
            set C::E::($this,n) [lindex $args 0]
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
    }
    new E {x y} {1 2} 3
    printArrays D:: E::
}
new C::E {x y} {1 2} 3
printArrays C::D:: C::E::
