source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1 x y X Y {1 2} 3
## b::b 1 x y X Y {1 2} 3
## a::(1,_derived) = ::b
## a::(1,m) = 1 2
## a::(1,p) = x y
## a::(1,q) = X Y
## b::(1,n) = 1 2

## A::A 2 x y X Y {1 2} 3
## B::B 2 x y X Y {1 2} 3
## A::(2,_derived) = ::B
## A::(2,m) = 1 2
## A::(2,p) = x y
## A::(2,q) = X Y
## B::(2,n) = 1 2

## d::d 3 x y X Y {1 2} 3
## e::e 3 x y X Y {1 2} 3
## c::d::(3,_derived) = ::c::e
## c::d::(3,m) = 1 2
## c::d::(3,p) = x y
## c::d::(3,q) = X Y
## c::e::(3,n) = 1 2

## D::D 4 x y X Y {1 2} 3
## E::E 4 x y X Y {1 2} 3
## D::(4,_derived) = ::C::E
## D::(4,m) = 1 2
## D::(4,p) = x y
## D::(4,q) = X Y
## E::(4,n) = 1 2

## D::D 5 x y X Y {1 2} 3
## E::E 5 x y X Y {1 2} 3
## C::D::(4,_derived) = ::C::E
## C::D::(4,m) = 1 2
## C::D::(4,p) = x y
## C::D::(4,q) = X Y
## C::D::(5,_derived) = ::C::E
## C::D::(5,m) = 1 2
## C::D::(5,p) = x y
## C::D::(5,q) = X Y
## C::E::(4,n) = 1 2
## C::E::(5,n) = 1 2

class a {}
proc a::a {this p q args} {
    puts "a::a $this $p $q $args"
    set a::($this,m) [lindex $args 0]
    set a::($this,p) $p
    set a::($this,q) $q
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p q args} a {$p $q $args} {
    puts "b::b $this $p $q $args"
    set b::($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}
new b {x y} {X Y} {1 2} 3
printArrays a:: b::

class A {
    proc A {this p q args} {
        puts "A::A $this $p $q $args"
        set A::($this,m) [lindex $args 0]
        set A::($this,p) $p
        set A::($this,q) $q
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p q args} A {$p $q $args} {
        puts "B::B $this $p $q $args"
        set B::($this,n) [lindex $args 0]
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
new B {x y} {X Y} {1 2} 3
printArrays A:: B::

class c {}
class c::d {}
proc c::d::d {this p q args} {
    puts "d::d $this $p $q $args"
    set c::d::($this,m) [lindex $args 0]
    set c::d::($this,p) $p
    set c::d::($this,q) $q
}
proc c::d::~d {this} {
    puts "d::~d $this"
}
class c::e {}
proc c::e::e {this p q args} c::d {$p $q $args} {
    puts "e::e $this $p $q $args"
    set c::e::($this,n) [lindex $args 0]
}
proc c::e::~e {this} {
    puts "e::~e $this"
}
new c::e {x y} {X Y} {1 2} 3
printArrays c::d:: c::e::

class C {
    class D {
        proc D {this p q args} {
            puts "D::D $this $p $q $args"
            set C::D::($this,m) [lindex $args 0]
            set C::D::($this,p) $p
            set C::D::($this,q) $q
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
    }
    class E {
        proc E {this p q args} C::D {$p $q $args} {
            puts "E::E $this $p $q $args"
            set C::E::($this,n) [lindex $args 0]
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
    }
    new E {x y} {X Y} {1 2} 3
    printArrays D:: E::
}
new C::E {x y} {X Y} {1 2} 3
printArrays C::D:: C::E::
