source parray.tcl
source stooop.tcl
namespace import stooop::*

### check multiple inheritance destruction order and data deallocation with a common indirect base class
# (see 73.tcl for nested class version)

# expected output:

## a::a 1
## b::b 1
## c::c 1
## a::a 1
## b::b 1
## d::d 1
## e::e 1
## a::(1,_derived) = ::d
## a::(1,m) = z
## b::(1,_derived) = ::d
## b::(1,n) = z
## c::(1,_derived) = ::e
## c::(1,o) = 1 2
## d::(1,_derived) = ::e
## d::(1,p) = z
## e::(1,q) = z
## e::~e 1
## d::~d 1
## b::~b 1
## a::~a 1
## c::~c 1
## b::~b 1
## a::~a 1

## A::A 2
## B::B 2
## C::C 2
## A::A 2
## B::B 2
## D::D 2
## E::E 2
## A::(2,_derived) = ::D
## A::(2,m) = z
## B::(2,_derived) = ::D
## B::(2,n) = z
## C::(2,_derived) = ::E
## C::(2,o) = 1 2
## D::(2,_derived) = ::E
## D::(2,p) = z
## E::(2,q) = z
## E::~E 2
## D::~D 2
## B::~B 2
## A::~A 2
## C::~C 2
## B::~B 2
## A::~A 2

class a {}
proc a::a {this p} {
    puts "a::a $this"
    set a::($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this p} {
    puts "b::b $this"
    set b::($this,n) $p
}
proc b::~b {this} {
    puts "b::~b $this"
}
class c {}
proc c::c {this p q r} a {$p} b {$q} {
    puts "c::c $this"
    set c::($this,o) $r
}
proc c::~c {this} {
    puts "c::~c $this"
}
class d {}
proc d::d {this p q r} a {$p} b {$q} {
    puts "d::d $this"
    set d::($this,p) $p
}
proc d::~d {this} {
    puts "d::~d $this"
}
class e {}
proc e::e {this p q r} c {$p $q $r} d {$q $q $r} {
    puts "e::e $this"
    set e::($this,q) $q
}
proc e::~e {this} {
    puts "e::~e $this"
}
set o [new e {x y} z {1 2}]
printArrays a:: b:: c:: d:: e::
delete $o
printArrays a:: b:: c:: d:: e::

class A {
    proc A {this p} {
        puts "A::A $this"
        set A::($this,m) $p
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this p} {
        puts "B::B $this"
        set B::($this,n) $p
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
class C {
    proc C {this p q r} A {$p} B {$q} {
        puts "C::C $this"
        set C::($this,o) $r
    }
    proc ~C {this} {
        puts "C::~C $this"
    }
}
class D {
    proc D {this p q r} A {$p} B {$q} {
        puts "D::D $this"
        set D::($this,p) $p
    }
    proc ~D {this} {
        puts "D::~D $this"
    }
}
class E {
    proc E {this p q r} C {$p $q $r} D {$q $q $r} {
        puts "E::E $this"
        set E::($this,q) $q
    }
    proc ~E {this} {
        puts "E::~E $this"
    }
}
set o [new E {x y} z {1 2}]
printArrays A:: B:: C:: D:: E::
delete $o
printArrays A:: B:: C:: D:: E::
