source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that optional arguments in constructors and multiple inheritance work together
# (see 74.tcl for nested class version)

# expected output:

## a::a 1
## b::b 1
## c::c 1
## a::(1,_derived) = ::c
## a::(1,m) = x y
## b::(1,_derived) = ::c
## b::(1,n) = z
## c::(1,o) = x y
## c::(1,p) = z
## c::~c 1
## b::~b 1
## a::~a 1
## a::a 2
## b::b 2
## c::c 2
## a::(2,_derived) = ::c
## a::(2,m) = 2
## b::(2,_derived) = ::c
## b::(2,n) = 3
## c::(2,o) = 2
## c::(2,p) = 3

## A::A 3
## B::B 3
## C::C 3
## A::(3,_derived) = ::C
## A::(3,m) = x y
## B::(3,_derived) = ::C
## B::(3,n) = z
## C::(3,o) = x y
## C::(3,p) = z
## C::~C 3
## B::~B 3
## A::~A 3
## A::A 4
## B::B 4
## C::C 4
## A::(4,_derived) = ::C
## A::(4,m) = 2
## B::(4,_derived) = ::C
## B::(4,n) = 3
## C::(4,o) = 2
## C::(4,p) = 3

class a {}
proc a::a {this {p 0}} {
    puts "a::a $this"
    set a::($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
class b {}
proc b::b {this {p 1}} {
    puts "b::b $this"
    set b::($this,n) $p
}
proc b::~b {this} {
    puts "b::~b $this"
}
class c {}
proc c::c {this {p 2} {q 3}} a {$p} b {$q} {
    puts "c::c $this"
    set c::($this,o) $p
    set c::($this,p) $q
}
proc c::~c {this} {
    puts "c::~c $this"
}
set o [new c {x y} z]
printArrays a:: b:: c::
delete $o
set o [new c]
printArrays a:: b:: c::

class A {
    proc A {this {p 0}} {
        puts "A::A $this"
        set A::($this,m) $p
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
class B {
    proc B {this {p 1}} {
        puts "B::B $this"
        set B::($this,n) $p
    }
    proc ~B {this} {
        puts "B::~B $this"
    }
}
class C {
    proc C {this {p 2} {q 3}} A {$p} B {$q} {
        puts "C::C $this"
        set C::($this,o) $p
        set C::($this,p) $q
    }
    proc ~C {this} {
        puts "C::~C $this"
    }
}
set o [new C {x y} z]
printArrays A:: B:: C::
delete $o
set o [new C]
printArrays A:: B:: C::
