source parray.tcl
source stooop.tcl
namespace import stooop::*

# expected output:

## a::a 1
## a::(1,m) = x
## a::(1,n) = y z
## a::~a 1

## A::A 2
## A::(2,m) = x
## A::(2,n) = y z
## A::~A 2

## d::d 3
## c::d::(3,m) = x
## c::d::(3,n) = y z
## d::~d 3

## D::D 4
## D::(4,m) = x
## D::(4,n) = y z
## D::~D 4
## D::D 5
## C::D::(5,m) = x
## C::D::(5,n) = y z
## D::~D 5

class a {}
proc a::a {this p q} {
    puts "a::a $this"
    set a::($this,m) $p
    set a::($this,n) $q
}
proc a::~a {this} {
    puts "a::~a $this"
}
set o [new a x {y z}]
printArrays a::
delete $o
printArrays a::

class A {
    proc A {this p q} {
        puts "A::A $this"
        set A::($this,m) $p
        set A::($this,n) $q
    }
    proc ~A {this} {
        puts "A::~A $this"
    }
}
set o [new A x {y z}]
printArrays A::
delete $o
printArrays A::

class c::d {}
proc c::d::d {this p q} {
    puts "d::d $this"
    set c::d::($this,m) $p
    set c::d::($this,n) $q
}
proc c::d::~d {this} {
    puts "d::~d $this"
}
set o [new c::d x {y z}]
printArrays c::d::
delete $o
printArrays c::d::

class C {
    class D {
        proc D {this p q} {
            puts "D::D $this"
            set C::D::($this,m) $p
            set C::D::($this,n) $q
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
    }
    set o [new D x {y z}]
    printArrays D::
    delete $o
    printArrays D::
}
set o [new C::D x {y z}]
printArrays C::D::
delete $o
printArrays C::D::
