source parray.tcl
source stooop.tcl
namespace import stooop::*

### check cloning operation in a 3 level deep class hierarchy

# expected output:

## a::(1,_derived) = ::b
## a::(1,x) = 0
## a::(2,_derived) = ::b
## a::(2,x) = 0
## b::(1,_derived) = ::c
## b::(1,y) = 1
## b::(2,_derived) = ::c
## b::(2,y) = 1
## c::(1,z) = 2
## c::(2,z) = 2

## A::(3,_derived) = ::B
## A::(3,x) = 0
## A::(4,_derived) = ::B
## A::(4,x) = 0
## B::(3,_derived) = ::C
## B::(3,y) = 1
## B::(4,_derived) = ::C
## B::(4,y) = 1
## C::(3,z) = 2
## C::(4,z) = 2

## d::e::(5,_derived) = ::d::f
## d::e::(5,x) = 0
## d::e::(6,_derived) = ::d::f
## d::e::(6,x) = 0
## d::f::(5,_derived) = ::d::g
## d::f::(5,y) = 1
## d::f::(6,_derived) = ::d::g
## d::f::(6,y) = 1
## d::g::(5,z) = 2
## d::g::(6,z) = 2

## E::(7,_derived) = ::D::F
## E::(7,x) = 0
## E::(8,_derived) = ::D::F
## E::(8,x) = 0
## F::(7,_derived) = ::D::G
## F::(7,y) = 1
## F::(8,_derived) = ::D::G
## F::(8,y) = 1
## G::(7,z) = 2
## G::(8,z) = 2

## D::E::(10,_derived) = ::D::F
## D::E::(10,x) = 0
## D::E::(7,_derived) = ::D::F
## D::E::(7,x) = 0
## D::E::(8,_derived) = ::D::F
## D::E::(8,x) = 0
## D::E::(9,_derived) = ::D::F
## D::E::(9,x) = 0
## D::F::(10,_derived) = ::D::G
## D::F::(10,y) = 1
## D::F::(7,_derived) = ::D::G
## D::F::(7,y) = 1
## D::F::(8,_derived) = ::D::G
## D::F::(8,y) = 1
## D::F::(9,_derived) = ::D::G
## D::F::(9,y) = 1
## D::G::(10,z) = 2
## D::G::(7,z) = 2
## D::G::(8,z) = 2
## D::G::(9,z) = 2

class a {}
proc a::a {this} {
    set a::($this,x) 0
}
class b {}
proc b::b {this} a {} {
    set b::($this,y) 1
}
class c {}
proc c::c {this} b {} {
    set c::($this,z) 2
}
new [new c]
printArrays a:: b:: c::

class A {
    proc A {this} {
        set A::($this,x) 0
    }
}
class B {
    proc B {this} A {} {
        set B::($this,y) 1
    }
}
class C {
    proc C {this} B {} {
        set C::($this,z) 2
    }
}
new [new C]
printArrays A:: B:: C::

class d {}
class d::e {}
proc d::e::e {this} {
    set d::e::($this,x) 0
}
class d::f {}
proc d::f::f {this} d::e {} {
    set d::f::($this,y) 1
}
class d::g {}
proc d::g::g {this} d::f {} {
    set d::g::($this,z) 2
}
new [new d::g]
printArrays d::e:: d::f:: d::g::

class D {
    class E {
        proc E {this} {
            set D::E::($this,x) 0
        }
    }
    class F {
        proc F {this} D::E {} {
            set D::F::($this,y) 1
        }
    }
    class G {
        proc G {this} D::F {} {
            set D::G::($this,z) 2
        }
    }
    new [new G]
    printArrays E:: F:: G::
}
new [new D::G]
printArrays D::E:: D::F:: D::G::
