source parray.tcl
source stooop.tcl
namespace import stooop::*

### check normal and user defined cloning operation with multiple inheritance and member objects
# (see 77.tcl for nested class version)

# expected output:

## a::(1,_derived) = ::d
## a::(1,m) = z
## a::(3,_derived) = ::d
## a::(3,m) = z
## b::(1,_derived) = ::d
## b::(1,n) = z
## b::(3,_derived) = ::d
## b::(3,n) = z
## c::(1,O) = 2
## c::(1,_derived) = ::e
## c::(1,o) = 1 2
## c::(3,O) = 4
## c::(3,_derived) = ::e
## c::(3,o) = 1 2
## d::(1,_derived) = ::e
## d::(1,p) = z
## d::(3,_derived) = ::e
## d::(3,p) = z
## e::(1,q) = z
## e::(3,q) = z
## f::(2,x) = 0
## f::(4,x) = 0

## A::(5,_derived) = ::D
## A::(5,m) = z
## A::(7,_derived) = ::D
## A::(7,m) = z
## B::(5,_derived) = ::D
## B::(5,n) = z
## B::(7,_derived) = ::D
## B::(7,n) = z
## C::(5,O) = 6
## C::(5,_derived) = ::E
## C::(5,o) = 1 2
## C::(7,O) = 8
## C::(7,_derived) = ::E
## C::(7,o) = 1 2
## D::(5,_derived) = ::E
## D::(5,p) = z
## D::(7,_derived) = ::E
## D::(7,p) = z
## E::(5,q) = z
## E::(7,q) = z
## F::(6,x) = 0
## F::(8,x) = 0

class a {}
proc a::a {this p} {
    set a::($this,m) $p
}
class b {}
proc b::b {this p} {
    set b::($this,n) $p
}
class c {}
proc c::c {this p q r} a {$p} b {$q} {
    set c::($this,o) $r
    set c::($this,O) [new f]
}
proc c::c {this copy} a {$a::($copy,m)} b 1 {
    set c::($this,o) $c::($copy,o)
    set c::($this,O) [new f]
}
class d {}
proc d::d {this p q r} a {$p} b {$q} {
    set d::($this,p) $p
}
class e {}
proc e::e {this p q r} c {$p $q $r} d {$q $q $r} {
    set e::($this,q) $q
}
class f {}
proc f::f {this} {
    set f::($this,x) 0
}
new [new e {x y} z {1 2}]
printArrays a:: b:: c:: d:: e:: f::

class A {
    proc A {this p} {
        set A::($this,m) $p
    }
}
class B {
    proc B {this p} {
        set B::($this,n) $p
    }
}
class C {
    proc C {this p q r} A {$p} B {$q} {
        set C::($this,o) $r
        set C::($this,O) [new F]
    }
    proc C {this copy} A {$A::($copy,m)} B 1 {
        set C::($this,o) $C::($copy,o)
        set C::($this,O) [new F]
    }
}
class D {
    proc D {this p q r} A {$p} B {$q} {
        set D::($this,p) $p
    }
}
class E {
    proc E {this p q r} C {$p $q $r} D {$q $q $r} {
        set E::($this,q) $q
    }
}
class F {
    proc F {this} {
        set F::($this,x) 0
    }
}
new [new E {x y} z {1 2}]
printArrays A:: B:: C:: D:: E:: F::
