source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that variable arguments in derived class work with base class constructor constant arguments

# expected output:

## a::a 1 x y z
## b::b 1 x y {1 2} 3
## a::(1,_derived) = ::b
## a::(1,m) = z

## A::A 2 x y z
## B::B 2 x y {1 2} 3
## A::(2,_derived) = ::B
## A::(2,m) = z

## d::d 3 x y z
## e::e 3 x y {1 2} 3
## c::d::(3,_derived) = ::c::e
## c::d::(3,m) = z

## D::D 4 x y z
## E::E 4 x y {1 2} 3
## D::(4,_derived) = ::C::E
## D::(4,m) = z

## D::D 5 x y z
## E::E 5 x y {1 2} 3
## C::D::(4,_derived) = ::C::E
## C::D::(4,m) = z
## C::D::(5,_derived) = ::C::E
## C::D::(5,m) = z

class a {}
proc a::a {this p args} {
    puts "a::a $this $p $args"
    set a::($this,m) [lindex $args 0]
}
proc a::~a {this} {}
class b {}
proc b::b {this p args} a {$p z} {
    puts "b::b $this $p $args"
    set b::($this,n) [lindex $args 0]
}
proc b::~b {this} {}
new b {x y} {1 2} 3
printArrays a::

class A {
    proc A {this p args} {
        puts "A::A $this $p $args"
        set A::($this,m) [lindex $args 0]
    }
    proc ~A {this} {}
}
class B {
    proc B {this p args} A {$p z} {
        puts "B::B $this $p $args"
        set B::($this,n) [lindex $args 0]
    }
    proc ~B {this} {}
}
new B {x y} {1 2} 3
printArrays A::

class c {}
class c::d {}
proc c::d::d {this p args} {
    puts "d::d $this $p $args"
    set c::d::($this,m) [lindex $args 0]
}
proc c::d::~d {this} {}
class c::e {}
proc c::e::e {this p args} c::d {$p z} {
    puts "e::e $this $p $args"
    set c::e::($this,n) [lindex $args 0]
}
proc c::e::~e {this} {}
new c::e {x y} {1 2} 3
printArrays c::d::

class C {
    class D {
        proc D {this p args} {
            puts "D::D $this $p $args"
            set C::D::($this,m) [lindex $args 0]
        }
        proc ~D {this} {}
    }
    class E {
        proc E {this p args} C::D {$p z} {
            puts "E::E $this $p $args"
            set C::E::($this,n) [lindex $args 0]
        }
        proc ~E {this} {}
    }
    new E {x y} {1 2} 3
    printArrays D::
}
new C::E {x y} {1 2} 3
printArrays C::D::
