source stooop.tcl
namespace import stooop::*

### check that multiple class definitions for the same class are possible

# expected output:
## 0
## 0
## 0

class a {
    proc a {this} {}
    proc ~a {this} {}
}
proc a::p {this p} {
    set a::($this,m) $p
}
class a {
    proc q {this} {
        puts $a::($this,m)
    }
}
set o [new a]
a::p $o 0
a::q $o

class b {
    class c {
        proc c {this} {}
        proc ~c {this} {}
    }
    proc c::p {this p} {
        set b::c::($this,m) $p
    }
    class c {
        proc q {this} {
            puts $b::c::($this,m)
        }
    }
    set o [new c]
    c::p $o 0
    c::q $o
}
set o [new b::c]
b::c::p $o 0
b::c::q $o
