source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that non qualified procedure invocation in derived class base class constructor arguments works

# expected output:

## a::(1,_derived) = ::b
## a::(1,m) = 1
## b::(1,n) = 0

## A::(2,_derived) = ::B
## A::(2,m) = 1
## B::(2,n) = 0

## c::d::(3,_derived) = ::c::e
## c::d::(3,m) = 1
## c::e::(3,n) = 0

## D::(4,_derived) = ::C::E
## D::(4,m) = 1
## E::(4,n) = 0

## C::D::(4,_derived) = ::C::E
## C::D::(4,m) = 1
## C::D::(5,_derived) = ::C::E
## C::D::(5,m) = 1
## C::E::(4,n) = 0
## C::E::(5,n) = 0

proc p {p} {error "::p invoked"}

class a {}
proc a::a {this p} {
    set a::($this,m) $p
}
proc a::~a {this} {}
class b {}
proc b::b {this p} a {[p $p]} {
    set b::($this,n) $p
}
proc b::~b {this} {}
proc b::p {p} {
    return [incr p]
}
new b 0
printArrays a:: b::

class A {
    proc A {this p} {
        set A::($this,m) $p
    }
    proc ~A {this} {}
}
class B {
    proc B {this p} A {[p $p]} {
        set B::($this,n) $p
    }
    proc ~B {this} {}
    proc p {p} {
        return [incr p]
    }
}
new B 0
printArrays A:: B::

class c {}
class c::d {}
proc c::d::d {this p} {
    set c::d::($this,m) $p
}
proc c::d::~d {this} {}
class c::e {}
proc c::e::e {this p} c::d {[p $p]} {
    set c::e::($this,n) $p
}
proc c::e::~e {this} {}
proc c::e::p {p} {
    return [incr p]
}
new c::e 0
printArrays c::d:: c::e::

class C {
    class D {
        proc D {this p} {
            set C::D::($this,m) $p
        }
        proc ~D {this} {}
    }
    class E {
        proc E {this p} C::D {[p $p]} {
            set C::E::($this,n) $p
        }
        proc ~E {this} {}
        proc p {p} {
            return [incr p]
        }
    }
    new E 0
    printArrays D:: E::
}
new C::E 0
printArrays C::D:: C::E::
