source parray.tcl
source stooop.tcl
namespace import stooop::*

### check static member initialization within class body

# expected output:

## a::(l) = 1 2
## A::(l) = 3 4
## b::c::(l) = 5 6
## C::(l) = 7 8
## B::C::(l) = 7 8 9 10

class a {
    set a::(l) {}
}
proc a::a {this} {
    lappend a::(l) $this
}
proc a::~a {this} {}
new a
new a
printArrays a::

class A {
    set A::(l) {}
    proc A {this} {
        lappend A::(l) $this
    }
    proc ~A {this} {}
}
new A
new A
printArrays A::

class b {}
class b::c {
    set b::c::(l) {}
}
proc b::c::c {this} {
    lappend b::c::(l) $this
}
proc b::c::~c {this} {}
new b::c
new b::c
printArrays b::c::

class B {
    class C {
        set B::C::(l) {}
        proc C {this} {
            lappend B::C::(l) $this
        }
        proc ~C {this} {}
    }
    new C
    new C
    printArrays C::
}
new B::C
new B::C
printArrays B::C::
