source parray.tcl
source stooop.tcl
namespace import stooop::*

### check user defined cloning operation in nested class context

# expected output:

## a::b::(1,x) = 0
## a::b::(2,x) = 1

## B::(3,x) = 0
## B::(4,x) = 1
## A::B::(3,x) = 0
## A::B::(4,x) = 1
## A::B::(5,x) = 0
## A::B::(6,x) = 1

class a {}
proc a::a {this} {}
class a::b {}
proc a::b::b {this} {
    set a::b::($this,x) 0
}
proc a::b::b {this copy} {
    set a::b::($this,x) [expr $a::b::($copy,x)+1]
}
new [new a::b]
printArrays a::b::

class A {
    proc A {this} {}
    class B {
        proc B {this} {
            set A::B::($this,x) 0
        }
        proc B {this copy} {
            set A::B::($this,x) [expr $A::B::($copy,x)+1]
        }
    }
    new [new B]
    printArrays B::
}
new [new A::B]
printArrays A::B::
