foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKPROCEDURES) {}
source stooop.tcl
namespace import stooop::*

### verify regular member procedure checking in procedure checking debug mode

# expected output:

## class b of ::b::p procedure not an ancestor of object 1 class a
## class B of ::B::p procedure not an ancestor of object 2 class A
## class c::e of ::c::e::p procedure not an ancestor of object 3 class c::d
## class C::E of ::C::E::p procedure not an ancestor of object 4 class C::D
## class C::E of ::C::E::p procedure not an ancestor of object 5 class C::D

class a {}
proc a::a {this} {}
proc a::p {this} {}
class b {}
proc b::b {this} {}
proc b::p {this} {}
set o [new a]
a::p $o
catch {b::p $o} message
puts $message

class A {
    proc A {this} {}
    proc p {this} {}
}
class B {
    proc B {this} {}
    proc p {this} {}
}
set o [new A]
A::p $o
catch {B::p $o} message
puts $message

class c {}
class c::d {}
proc c::d::d {this} {}
proc c::d::p {this} {}
class c::e {}
proc c::e::e {this} {}
proc c::e::p {this} {}
set o [new c::d]
c::d::p $o
catch {c::e::p $o} message
puts $message

class C {
    class D {
        proc D {this} {}
        proc p {this} {}
    }
    class E {
        proc E {this} {}
        proc p {this} {}
    }
    set o [new D]
    D::p $o
    catch {E::p $o} message
    puts $message
}
set o [new C::D]
C::D::p $o
catch {C::E::p $o} message
puts $message
