foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKPROCEDURES) {}
source stooop.tcl
namespace import stooop::*

### verify regular member procedure checking within multiple inheritance class hierarchy in procedure checking debug mode

## class b of ::b::p procedure not an ancestor of object 1 class a
## class c of ::c::p procedure not an ancestor of object 1 class a
## class B of ::B::p procedure not an ancestor of object 2 class A
## class C of ::C::p procedure not an ancestor of object 2 class A
## class d::f of ::d::f::p procedure not an ancestor of object 3 class d::e
## class d::g of ::d::g::p procedure not an ancestor of object 3 class d::e
## class D::F of ::D::F::p procedure not an ancestor of object 4 class D::E
## class D::G of ::D::G::p procedure not an ancestor of object 4 class D::E
## class D::F of ::D::F::p procedure not an ancestor of object 5 class D::E
## class D::G of ::D::G::p procedure not an ancestor of object 5 class D::E

class a {}
proc a::a {this} {}
proc a::p {this} {}
class b {}
proc b::b {this} {}
proc b::p {this} {}
class c {}
proc c::c {this} a {} b {} {}
proc c::p {this} {}
set o [new a]
a::p $o
catch {b::p $o} message
puts $message
catch {c::p $o} message
puts $message

class A {
    proc A {this} {}
    proc p {this} {}
}
class B {
    proc B {this} {}
    proc p {this} {}
}
class C {
    proc C {this} A {} B {} {}
    proc p {this} {}
}
set o [new A]
A::p $o
catch {B::p $o} message
puts $message
catch {C::p $o} message
puts $message

class d {}
class d::e {}
proc d::e::e {this} {}
proc d::e::p {this} {}
class d::f {}
proc d::f::f {this} {}
proc d::f::p {this} {}
class d::g {}
proc d::g::g {this} d::e {} d::f {} {}
proc d::g::p {this} {}
set o [new d::e]
d::e::p $o
catch {d::f::p $o} message
puts $message
catch {d::g::p $o} message
puts $message

class D {
    class E {
        proc E {this} {}
        proc p {this} {}
    }
    class F {
        proc F {this} {}
        proc p {this} {}
    }
    class G {
        proc G {this} D::E {} D::F {} {}
        proc p {this} {}
    }
    set o [new E]
    E::p $o
    catch {F::p $o} message
    puts $message
    catch {G::p $o} message
    puts $message
}
set o [new D::E]
D::E::p $o
catch {D::F::p $o} message
puts $message
catch {D::G::p $o} message
puts $message
