foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKDATA) {}
source stooop.tcl
namespace import stooop::*

### verify member writing and unsetting within class namespaces in member data checking mode
### it seems that unset tracing prevents error reporting at this time (bug?) ###

## can't set "a::(m)": class access violation in class b namespace
## can't set "a::(1,n)": class access violation in class b namespace
## bug
## bug
## can't set "A::(m)": class access violation in class B namespace
## can't set "A::(2,n)": class access violation in class B namespace
## bug
## bug
## can't set "c::d::(m)": class access violation in class c::e namespace
## can't set "c::d::(3,n)": class access violation in class c::e namespace
## bug
## bug
## can't set "C::D::(m)": class access violation in class C::B namespace
## can't set "C::D::(4,n)": class access violation in class C::B namespace
## bug
## bug
## can't read "C::D::(m)": no such element in array
## can't read "C::D::(4,n)": no such element in array
## bug
## bug

class a {
    set a::(m) 0
}
proc a::a {this} {
    set a::($this,n) 0
}
proc a::~a {this} {}
set o [new a]
catch {class b {incr a::(m)}} message; puts $message
catch {class b {incr a::($o,n)}} message; puts $message
catch {class b {unset a::(m)}} message; puts bug
catch {class b {unset a::($o,n)}} message; puts bug
delete $o

class A {
    set A::(m) 0
    proc A {this} {
        set A::($this,n) 0
    }
    proc ~A {this} {}
}
set o [new A]
class B {
    catch {incr A::(m)} message; puts $message
    catch {incr A::($o,n)} message; puts $message
    catch {unset A::(m)} message; puts bug
    catch {unset A::($o,n)} message; puts bug
}
delete $o

class c {}
class c::d {
    set c::d::(m) 0
}
proc c::d::d {this} {
    set c::d::($this,n) 0
}
proc c::d::~d {this} {}
set o [new c::d]
catch {class c::e {incr c::d::(m)}} message; puts $message
catch {class c::e {incr c::d::($o,n)}} message; puts $message
catch {class c::e {unset c::d::(m)}} message; puts bug
catch {class c::e {unset c::d::($o,n)}} message; puts bug
delete $o

class C {
    class D {
        set C::D::(m) 0
        proc D {this} {
            set C::D::($this,n) 0
        }
        proc ~D {this} {}
    }
    set ::o [new D]
    class B {
        catch {incr C::D::(m)} message; puts $message
        catch {incr C::D::($o,n)} message; puts $message
        catch {unset C::D::(m)} message; puts bug
        catch {unset C::D::($o,n)} message; puts bug
    }
}
catch {incr C::D::(m)} message; puts $message
catch {incr C::D::($o,n)} message; puts $message
catch {unset C::D::(m)} message; puts bug
catch {unset C::D::($o,n)} message; puts bug
delete $o
