foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKDATA) {}
source stooop.tcl
namespace import stooop::*

### verify both data and procedure static access in member data checking mode

## can't set "b::(o)": class access violation in procedure ::a::p
## can't set "b::(1,p)": class access violation in procedure ::a::q
## can't set "a::(m)": class access violation in procedure ::b::r
## can't set "a::(1,n)": class access violation in procedure ::b::s

## can't set "B::(o)": class access violation in procedure ::A::p
## can't set "B::(2,p)": class access violation in procedure ::A::q
## can't set "A::(m)": class access violation in procedure ::B::r
## can't set "A::(2,n)": class access violation in procedure ::B::s

## can't set "c::e::(o)": class access violation in procedure ::c::d::p
## can't set "c::e::(3,p)": class access violation in procedure ::c::d::q
## can't set "c::d::(m)": class access violation in procedure ::c::e::r
## can't set "c::d::(3,n)": class access violation in procedure ::c::e::s

## can't set "C::E::(o)": class access violation in procedure ::C::D::p
## can't set "C::E::(4,p)": class access violation in procedure ::C::D::q
## can't set "C::D::(m)": class access violation in procedure ::C::E::r
## can't set "C::D::(4,n)": class access violation in procedure ::C::E::s
## can't set "C::E::(o)": class access violation in procedure ::C::D::p
## can't set "C::E::(4,p)": class access violation in procedure ::C::D::q
## can't set "C::D::(m)": class access violation in procedure ::C::E::r
## can't set "C::D::(4,n)": class access violation in procedure ::C::E::s

class a {
    set a::(m) 0
}
proc a::a {this} {
    set a::($this,n) 0
}
proc a::~a {this} {}
proc a::p {this} {
    incr a::(m)
    incr b::(o)
}
proc a::q {object} {
    incr a::($object,n)
    incr b::($object,p)
}
class b {
    set b::(o) 0
}
proc b::b {this} a {} {
    set b::($this,p) 0
}
proc b::~b {this} {}
proc b::r {this} {
    incr b::(o)
    incr a::(m)
}
proc b::s {object} {
    incr b::($object,p)
    incr a::($object,n)
}
set o [new b]
catch {a::p $o} message; puts $message
catch {a::q $o} message; puts $message
catch {b::r $o} message; puts $message
catch {b::s $o} message; puts $message
delete $o

class A {
    set A::(m) 0
    proc A {this} {
        set A::($this,n) 0
    }
    proc ~A {this} {}
    proc p {this} {
        incr A::(m)
        incr B::(o)
    }
    proc q {object} {
        incr A::($object,n)
        incr B::($object,p)
    }
}
class B {
    set B::(o) 0
    proc B {this} A {} {
        set B::($this,p) 0
    }
    proc ~B {this} {}
    proc r {this} {
        incr B::(o)
        incr A::(m)
    }
    proc s {object} {
        incr B::($object,p)
        incr A::($object,n)
    }
}
set o [new B]
catch {A::p $o} message; puts $message
catch {A::q $o} message; puts $message
catch {B::r $o} message; puts $message
catch {B::s $o} message; puts $message
delete $o

class c {}
class c::d {
    set c::d::(m) 0
}
proc c::d::d {this} {
    set c::d::($this,n) 0
}
proc c::d::~d {this} {}
proc c::d::p {this} {
    incr c::d::(m)
    incr c::e::(o)
}
proc c::d::q {object} {
    incr c::d::($object,n)
    incr c::e::($object,p)
}
class c::e {
    set c::e::(o) 0
}
proc c::e::e {this} c::d {} {
    set c::e::($this,p) 0
}
proc c::e::~e {this} {}
proc c::e::r {this} {
    incr c::e::(o)
    incr c::d::(m)
}
proc c::e::s {object} {
    incr c::e::($object,p)
    incr c::d::($object,n)
}
set o [new c::e]
catch {c::d::p $o} message; puts $message
catch {c::d::q $o} message; puts $message
catch {c::e::r $o} message; puts $message
catch {c::e::s $o} message; puts $message
delete $o

class C {
    class D {
        set C::D::(m) 0
        proc D {this} {
            set C::D::($this,n) 0
        }
        proc ~D {this} {}
        proc p {this} {
            incr C::D::(m)
            incr C::E::(o)
        }
        proc q {object} {
            incr C::D::($object,n)
            incr C::E::($object,p)
        }
    }
    class E {
        set C::E::(o) 0
        proc E {this} C::D {} {
            set C::E::($this,p) 0
        }
        proc ~E {this} {}
        proc r {this} {
            incr C::E::(o)
            incr C::D::(m)
        }
        proc s {object} {
            incr C::E::($object,p)
            incr C::D::($object,n)
        }
    }
    set ::o [new E]
    catch {D::p $o} message; puts $message
    catch {D::q $o} message; puts $message
    catch {E::r $o} message; puts $message
    catch {E::s $o} message; puts $message
}
catch {C::D::p $o} message; puts $message
catch {C::D::q $o} message; puts $message
catch {C::E::r $o} message; puts $message
catch {C::E::s $o} message; puts $message
delete $o
