#
# $Source: /home/nlfm/Zircon/lib/RCS/Sound.tcl,v $
# $Date: 1998/06/12 15:04:25 $
# $Revision: 1.18.1.13 $
#
package provide zircon 1.18
#
proc handleSound {net usr fl chan prefix} {
    global zircon
    switch {} [$net wavplayer] {} default {
	switch [file pathtype $fl] absolute {
	    set dirs [file dirname $fl]
	    set fl [file tail $fl]
	} default {
	    set dirs [split [$net wavpath] :]
	    lappend dirs [file join $zircon(prefdir) sounds] \
	      [file join $zircon(lib) sounds]
	}
	switch {} [file extension $fl] {append fl .wav}
	foreach x $dirs {
	    if {[file exists [file join $x $fl]]} {
		set fl "[file join $x $fl]"
		if {[regsub -all %s [$net wavplayer] $fl cmd] == 0} {
		    append cmd " [list $fl]"
		}
		if {[catch {eval exec $cmd &} msg]} {
		    $net inform "Error executing wav player - \"$msg\""
		}
		return
	    }
	}
	switch {} $chan {} default {
	    handleOn $net NOSOUND [list $fl $chan $prefix]
	}
    }
}
#
proc doSendSound {net nk fl} {
    switch {} $fl return
    set tfl [file tail [file rootname $fl]]
    $net CTCP SOUND $nk "[file tail $fl] <$tfl>"
    handleSound $net [$net nickname] $fl {} {}
}
#
proc addSoundMenu {net menu chid} {
    switch {} [$net wavplayer] return
    global zircon
    $menu add cascade -label [trans sound] -menu $menu.sound
    menu $menu.sound -postcommand "buildSMenu $net $menu.sound $chid"
    catch {$menu.sound configure  -tearoffcommand "retitle {Sounds for [$chid name]}"}
}
#
proc buildSMenu {net menu chid} {
    global zircon
    $menu delete 0 end
    catch {destroy $menu.more}
    set ptn {*.[wW][aA][vV]}
    set wavs {}
    set dirs [split [$net wavpath] :]
    lappend dirs [file join $zircon(prefdir) sounds] \
      [file join $zircon(lib) sounds]
    foreach x $dirs {
	switch {} [set wvs [glob -nocomplain [file join $x $ptn]]] {} default {
	    foreach y $wvs { lappend wavs [file tail $y] }
	}
    }
    switch {} $wavs {
	foreach y [glob -nocomplain $ptn] { lappend wavs [file tail $y] }
    }
    $menu add command -label {Other file} -command "sendSound $net {[$chid name]}"
    $menu add separator
    set cnt 0
    foreach x [lsort $wavs] {
        if {[incr cnt] > 20} {
	    set cnt 1
	    set m [menu $menu.more -tearoff 0]
	    $menu add cascade -label [trans more] -menu $m
	    set menu $m
	}
	$menu add command -label [file tail [file rootname $x]] \
	  -command "doSendSound $net {[$chid name]} {$x}"
    }
}
