

/*
 * Copyright (c) 1983, 1988 The Regents of the University of California.
 * All rights reserved
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/*
 * Exec a tcsh process, dup'in the specified "fd" as its
 * standard input, standard output and standard error.
 */

#include        <stdio.h>
#include        <unistd.h>
#include        "systype.h"
#include        "chichotConfig.h"

exec_tcsh(fd, argv, envp)
  int     fd;         /* communication channel */
  char    **argv;
  char    **envp;
{
     char    *getenv(), *rindex();
     char    *newargv[2];
     
     close(0); close(1); close(2);
     if (dup(fd) != 0 || dup(fd) != 1 || dup(fd) != 2)
	  err_sys("dup error");
     close(fd);
     
     /*
      * We must set up the pathname of the shell to be exec'ed,
      * and its argv[0].
      */
     
     if ( (argv[0] = rindex(shell, '/')) != NULL)
	  argv[0]++;      /* step past rightmost slash */
     else
	  argv[0] = (char*)shell;   /* no slashes in pathname */
     newargv[0] = argv[0];
     newargv[1] = NULL;
     
     execve(shell, newargv, envp);
     err_sys("execve error");
     /* NOTREACHED */
}
