# Copyright (c) 1994 by Sanjay Ghemawat
#############################################################################
# Dialog to get date range
#
# Commands
#
#	get_daterange <leader> <startvar> <finishvar>
#
#	Interact with user to get date range.  The initial values of
#	the variables named by <startvar> and <finishvar> are used to
#	initialize the range display.  When interaction is finished,
#	the selected range is stored in <startvar> and <finishvar>.
#	Returns true iff interaction is not cancelled by the user.

# Hidden global variables
#
#	dr_state(done)		Interaction has finished
#	dr_state(start)		Starting date
#	dr_state(finish)	Finishing date
#	dr_state(se)		Starting date editor
#	dr_state(fe)		Finishing date editor

set dr_state(done)	0
set dr_state(start)	0
set dr_state(finish)	0
set dr_state(se)	{}
set dr_state(fe)	{}

proc get_daterange {leader svar fvar} {
    dr_init

    # Initialize state
    global dr_state
    upvar $svar start
    upvar $fvar finish
    set dr_state(start)  $start
    set dr_state(finish) $finish
    
    if ![dr_interact $leader] {return 0}

    set start  $dr_state(start)
    set finish $dr_state(finish)
    return 1
}

proc dr_init {} {
    global dr_state
    set f .dr_dialog
    if [winfo exists $f] {return}

    toplevel $f -class Dialog -geometry ""
    wm title $f "Select Range"
    wm iconname $f "Range"
    wm protocol $f WM_DELETE_WINDOW {set dr_state(done) 0}

    frame $f.top -relief raised -bd 1
    message $f.text -aspect 800 -text {Restrict item repetition range...}
    pack $f.text -in $f.top -side top -expand 1 -fill both -padx 5m -pady 5m

    set dr_state(se) [DateEditor $f.start  0 dr_starter]
    set dr_state(fe) [DateEditor $f.finish 0 dr_finisher]
    label $f.to -text To -padx 10m -pady 10m -relief raised -bd 1

    make_buttons $f.bot 1 {
	{Cancel		{set dr_state(done) 0}}
	{Okay		{set dr_state(done) 1}}
    }

    pack $f.top -side top -fill both -expand 1
    pack $f.bot -side bottom -fill x

    pack $f.start -side left -expand 1 -fill both
    pack $f.finish -side right -expand 1 -fill both
    pack $f.to -side left -expand 1 -fill both

    bind $f <Control-c> {set dr_state(done) 0}
    bind $f <Return>    {set dr_state(done) 1}

    wm withdraw $f
    update
}

proc dr_set_start {d} {
    global dr_state
    set dr_state(start) $d
    if {$dr_state(finish) < $d} {
	set dr_state(finish) $d
    }
    $dr_state(se) set_date $dr_state(start)
    $dr_state(fe) set_date $dr_state(finish)
}

proc dr_set_finish {d} {
    global dr_state
    set dr_state(finish) $d
    if {$dr_state(start) > $d} {
	set dr_state(start) $d
    }
    $dr_state(se) set_date $dr_state(start)
    $dr_state(fe) set_date $dr_state(finish)
}

proc dr_interact {leader} {
    global dr_state
    set f .dr_dialog

    $dr_state(se) set_date $dr_state(start)
    $dr_state(fe) set_date $dr_state(finish)

    set dr_state(done) -1
    dialog_run $leader $f $f dr_state(done)
    return $dr_state(done)
}

# Create fake view objects for DateEditor callbacks
proc dr_starter {cmd args} {
    global dr_state
    switch -exact -- $cmd {
	window		{return .dr_dialog}
	date		{return $dr_state(start)}
	set_date	{dr_set_start [lindex $args 0]}
	select		{}
	unselect	{}
	itemwindow	{return ""}
	default		{error "unknown view operation: \"$cmd\""}
    }
}

proc dr_finisher {cmd args} {
    global dr_state
    switch -exact -- $cmd {
	window		{return .dr_dialog}
	date		{return $dr_state(finish)}
	set_date	{dr_set_finish [lindex $args 0]}
	select		{}
	unselect	{}
	itemwindow	{return ""}
	default		{error "unknown view operation: \"$cmd\""}
    }
}
