#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>

#define if_for_selwin "__SelectWindow__"

static char *display_name = NULL;
static Display *display;
static Window root;
static Window window = None;
static XKeyEvent event;

Window
WindowParent (Window w)
{
  Window wroot, parent, *children;
  unsigned int nchildren;

  if (XQueryTree (display, w, &wroot, &parent, &children, &nchildren))
    {
      XFree ((char *) children);
      return (parent);
    }
  else
    {
      throw_exception ("XQueryTree failed!");
      return ((Window) NULL);
    }
}

/* Added for window managers like swm and tvtwm that follow solbourne's
 * virtual root window concept
 */
Window
GetRootWindow (Display * disp, int scrn)
{
  Atom __SWM_VROOT = None;
  Window root, rootReturn, parentReturn, *children;
  unsigned int numChildren;
  int i;

  root = RootWindow (disp, scrn);

  /* see if there is a virtual root */
  __SWM_VROOT = XInternAtom (disp, "__SWM_VROOT", False);
  XQueryTree (disp, root, &rootReturn, &parentReturn, &children, &numChildren);
  for (i = 0; i < numChildren; i++)
    {
      Atom actual_type;
      int actual_format;
      unsigned long nitems, bytesafter;
      Window *newRoot = (Window) 0;

      if (XGetWindowProperty (disp, children[i], __SWM_VROOT, 0, 1,
			      False, XA_WINDOW, &actual_type, &actual_format,
			      &nitems, &bytesafter,
			      (unsigned char **) &newRoot) ==
	  Success && newRoot)
	{
	  root = *newRoot;
	  break;
	}
    }
  if (children)
    XFree ((char *) children);
  return (root);
}


/*      -       -       -       -       -       -       -       -       -

 * [These functions are from the file "dsimple.c" used with xwininfo.]
 *
 * Written by Mark Lillibridge.   Last updated 7/1/87
 *
 *
 * Window_With_Name: routine to locate a window with a given name on a display.
 *                   If no window with the given name is found, 0 is returned.
 *                   If more than one window has the given name, the first
 *                   one found will be returned.  Only top and its subwindows
 *                   are looked at.  Normally, top should be the Root Window.
 */
Window
Window_With_Name (Display * dpy, Window top, char *name)
{
  Window *children, dummy;
  unsigned int nchildren;
  int i;
  Window w = 0;
  char *window_name;

  if (XFetchName (dpy, top, &window_name) && !strcmp (window_name, name))
    return (top);

  if (!XQueryTree (dpy, top, &dummy, &dummy, &children, &nchildren))
    return (0);

  for (i = 0; i < nchildren; i++)
    {
      w = Window_With_Name (dpy, children[i], name);
      if (w)
	break;
    }
  if (children)
    XFree ((char *) children);
  return (w);
}


/*
 * Routine to let user select a window using the mouse
 * gf: Doesn't need "screen" defined.
 * gf: Uses global "root" rather than calling DefaultRootWindow() again,
 *     also so virtual root windows can be handled.
 */
Window
Select_Window (dpy)
     Display *dpy;
{
  Cursor cursor;
  Window target_win = None;
  Window win_root;
  XEvent event;
  int status, dummyi;
  unsigned int dummy;
  int buttons = 0;

  cursor = XCreateFontCursor (dpy, XC_crosshair);
  /* Grab the pointer using target cursor, letting it room all over */
  status = XGrabPointer (dpy, root, False,
			 ButtonPressMask | ButtonReleaseMask, GrabModeSync,
			 GrabModeAsync, root, cursor, CurrentTime);
  if (status != GrabSuccess)
    {
      throw_exception ("can't grab pointer");
      return (None);
    }
  /* Let the user select a window... */
  while ((target_win == None) || (buttons != 0))
    {
      /* allow one more event */
      XAllowEvents (dpy, SyncPointer, CurrentTime);
      XWindowEvent (dpy, root, ButtonPressMask | ButtonReleaseMask, &event);
      switch (event.type)
	{
	case ButtonPress:
	  if (target_win == None)
	    {
	      if ((target_win = event.xbutton.subwindow) != (Window) NULL &&
	      XGetGeometry (display, target_win, &win_root, &dummyi, &dummyi,
			    &dummy, &dummy, &dummy, &dummy) &&
		  target_win != win_root)
		{
		  target_win = XmuClientWindow (display, target_win);
		}
	      if (target_win == None)
		target_win = root;
	    }
	  buttons++;
	  break;
	case ButtonRelease:
	  if (buttons > 0)	/* there may have been some down before we started */
	    buttons--;
	  break;
	}
    }

  XUngrabPointer (dpy, CurrentTime);	/* Done with pointer */
  XFreeCursor (dpy, cursor);
  return (target_win);
}


static int
open_channel (char *wname)
{
/* display_name = ":0.0"; */
  if ((display = XOpenDisplay (display_name)) == NULL)
    {
      throw_exception ("can't open display");
      return 1;
    }
  if ((root = GetRootWindow (display, DefaultScreen (display))) == 0)
    {
      throw_exception ("Cannot get DefaultScreen");
      return 1;
    }

  if ((wname[0] == '\0') && (window == None))	/* no window name specified, get a new window */
    {
      if ((window = Select_Window (display)) == None)
	{
	  throw_exception ("Cannot select a window");
	  return 1;
	}
    }
  else if ((wname[0] == '\0') && (window != None))
	{} /* take selected window */
  else if ((wname[0] == '_') && (!strcmp (wname, if_for_selwin)))
    /* special mode to select new window */
    {
      if ((window = Select_Window (display)) == None)
	{
	  throw_exception ("Cannot select the window");
	  return 1;
	}
    }
  else if (wname[0] != '\0')
    {
      if ((window = Window_With_Name (display, root, wname)) == None)
	{
	  throw_exception3s ("Display %s: can't open window named \"%s\"",
			     XDisplayName (display_name), wname);
	  return 1;
	}
    }
  else
    {
      throw_exception3 ("bad condition in %s at line %d", __FILE__, __LINE__);
      return 1;
    }

  event.type = KeyPress;
  event.serial = 0;
  event.send_event = False;
  event.display = display;
  event.x = event.y = event.x_root = event.y_root = 0;
  event.time = CurrentTime;
  event.same_screen = True;
  event.subwindow = None;
  event.window = window;
  event.root = root;
  return 0;
}

static void
close_channel ()
{
/* XFlush(display); */
  XCloseDisplay (display);
}

static void
sendx_channel (KeySym ks)
{
/* 0=regular, 1=shift, 2=lock, 4=control */
  if (ks < 256)
    {
      event.state = isupper ((char) ks);
      switch (ks)
	{
	case 0x08:
	  ks = XK_BackSpace;
	  break;
	case 0x09:
	  ks = XK_Tab;
	  break;
	case 0x0A:
	  ks = XK_Linefeed;
	  break;
	case 0x0B:
	  ks = XK_Clear;
	  break;
	case 0x0D:
	  ks = XK_Return;
	  break;
	case 0x13:
	  ks = XK_Pause;
	  break;
	case 0x14:
	  ks = XK_Scroll_Lock;
	  break;
	case 0x15:
	  ks = XK_Sys_Req;
	  break;
	case 0x1B:
	  ks = XK_Escape;
	  break;
	}
    }
  else
    event.state = 0;
  event.keycode = XKeysymToKeycode (display, ks);
  if (XSendEvent (display, window, True, 0xfff, (XEvent *) & event) == 0)
    throw_exception ("Error in XSendEvent");
  return;
}

void
sendx_string (char *string, char *window)
{
  char *p;
  if (open_channel (window))
    return;
  p = string;
  while (*p)
    sendx_channel (*p++);
  close_channel ();
}

void
sendx_token (char *string, char *window)
{
  if (open_channel (window))
    return;
  sendx_channel (XStringToKeysym (string));
  close_channel ();
}

/*
   void
   PrintKeySyms ()
   {
   int i;
   for (i = 32; i < 127; i++)
   {
   printf ("%s[%c] ", XKeysymToString (i), i);
   }
   for (i = 128 + 32; i < 128 + 127; i++)
   {
   printf ("%s[%c] ", XKeysymToString (i), i);
   }
   printf ("\n");
   }
 */
