%title "Module Sendx", nosort,after
%module sendx
 
%section "Introduction",nosort
%text %{
This is a loadable TCL module which implements commands that allow to send 
strings or XStrings to any X11 window via the XSendEvent function.
<p>
As an example you can execute 
<pre>   sendx_string "ls -lg\r"
</pre> to send the string "ls -lg" to a xterm window which executes this
command then directly in a shell.
<p>
The intention of these functions is to help to interface to programs that
have no scripting capabilities and no other ways than keyboard input is
availiable to communicate with those programs.
<p>
The idea came from the Xse 2.1 package written by George Ferguson (ferguson@cs.rochester.edu).
This library also uses some code from this package.
<p>
Many thanks also to David M. Beazley (beazley@cs.utah.edu) who write the nice
SWIG package which is used here to link the C-functions into TCL.
<p>
%}
 
 
%{
#include <tcl.h>

static char error_message[256];
static int error_status = 0;
 
void throw_exception3(char *msg, char *s, int i) {
    sprintf(error_message, msg, s, i);
    error_status = 1;
}
 
void throw_exception3s(char *msg1, char *msg2, char *msg3) {
    sprintf(error_message, msg1, msg2, msg3);
    error_status = 1;
}

void throw_exception2(char *msg, int i) {
    sprintf(error_message, msg, i);
    error_status = 1;
}
 
void clear_exceptions(void) {
        error_status = 0;
}

void throw_exception(char *msg) {
    strncpy(error_message,msg,256);
    error_status = 1;
}
 
%}
 
%except(tcl8) {
  error_status = 0;
  $function    /* Gets substituted by actual function call */
  if (error_status)
        {
        Tcl_SetStringObj(tcl_result, error_message, -1);
        return TCL_ERROR;
        }
}

%init %{
   Tcl_PkgProvide(interp, "Sendx", "0.1");
%}

%section "Availiable TCL commands"
%subsection "sendx_string"
extern void sendx_string (char *string, char *window = "");
/*
<p>
The string "string" is sent to the X11-window named "window". If the
window name is not specified or has a value of "" then the previously
selected window is used again as target.
<p>
If no window has been selected 
the user can select the window by clicking with any mouse button
into it. This window is then also used for future requests. The name of
a window is the same that is reported by the command xwininfo.
<p>
If "__SelectWindow__" is used for window name then the user is 
requested to select a window by clicking on it.
*/

%subsection "sendx_token"
extern void sendx_token (char *string, char *window = "");
/*
<p>
The Xstring "string" is sent to the X11-window named "window".
The function XStringToKeysym is used to convert this string into a
valid Keysym. As an example you can execute
<pre>
   sendx_token  "F5"
</pre>
to send the event keypress funtion key "F5" to a window. please refer
to <X11/keysymdef.h> for availiable tokens for this function.
<p>
If the window name is not specified or has a value of "" then the previously
selected window is used again as target.
<p>
If no window has been selected 
the user can select the window by clicking with any mouse button
into it. This window is then also used for future requests. The name of
a window is the same that is reported by the command xwininfo.
<p>
If "__SelectWindow__" is used for window name then the user is
requested to select a window by clicking on it.
<p>
*/

%section "How to build and install the library"
%text %{
This library was developed under Linux 2.0 using gcc 2.7.2 and it may
run without modification on other platforms also. It contains X11 functions
so it is not portable to non-X11 platforms.
<p>
You need to install Tcl 8.0, Tk 8.0 and Swig 1.1 on your machine to 
build this library. The library uses the new object interface of Tcl 8.0.
<p>
You need change the compiler settings at the beginning of your makefile
so that they comply with the requirements of your compiler. Then you can
type "make" to build your library. A small test can be run with "make test".
if everything is ok you can install the library with "make install". This
puts the library per default in the directory "/usr/local/lib/tclso" and
also builds a "pkgIndex.tcl" which can be used for autoloading.
<p>
%}

%section "COPYRIGHT AND LICENSE TERMS"
%text %{
(This text was taken from the Tcl/Tk license)
<p>
The Sendx library is copyrighted by Reinhard Fobbe, Munich, Germany.
The following terms apply to all files associated with the software unless
explicitly disclaimed in individual files.
<p>
The authors hereby grant permission to use, copy, modify, distribute,
and license this software and its documentation for any purpose, provided
that existing copyright notices are retained in all copies and that this
notice is included verbatim in any distributions. No written agreement,
license, or royalty fee is required for any of the authorized uses.
Modifications to this software may be copyrighted by their authors
and need not follow the licensing terms described here, provided that
the new terms are clearly indicated on the first page of each file where
they apply.
<p>
IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
<p>
THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
MODIFICATIONS.
<p>
%}
 
%section "Changes"
%text %{
This is the first public release 0.1. There are no changes availiable.
<p>
%}
%section "How to reach me"
%text %{
Please send your comments via email to
<a href=mailto:reinhard@cadence.com>Reinhard Fobbe</a>.
<p>
%}
