# TkMan interface for tkgoodstuff
# Gary Dezern (gdezern@uniquecr.sundial.net)
#
# Developed with tkgoodstuff v4.1b6...  
#

proc TkManDeclare {} {
    set Prefs_taborder(:Clients,TkMan) "Misc Button"
    set Prefs_taborder(:Clients,TkMan,Button) "Misc Colors"
    TKGDeclare TkMan(pathname) {tkman} \
        -typelist [list Clients TkMan Misc]\
        -label "full pathname of \"tkman\" (or just tkman if its on your path)"
    TKGDeclare TkMan(foreground) {$TKG(buttonforeground)}\
        -typelist [list Clients TkMan Button Colors]
    TKGDeclare TkMan(activeforeground) {$TkMan(foreground)}\
        -typelist [list Clients TkMan Button Colors]
    TKGDeclare TkMan(background) {$TKG(buttonbackground)}\
        -typelist [list Clients TkMan Button Colors]
    TKGDeclare TkMan(activebackground) {$TKG(butactivebackground)}\
        -typelist [list Clients TkMan Button Colors]
    TKGDeclare TkMan(nolabel) {$TKG(iconsonly)}\
        -typelist [list Clients TkMan Button Misc]\
        -label "Omit the text label (1 or 0)"
    TKGDeclare TkMan(noicon) {$TKG(labelsonly)}\
        -typelist [list Clients TkMan Button Misc]\
        -label "Omit the icon (1 or 0)"
    TKGDeclare TkMan(iconside) ""\
	-label "Side of icon on button" -vartype radio\
	-radioside left\
	-radiolist {{left left} {right right} {top top} 
	    {bottom bottom} {background background}} \
	-typelist [list Clients TkMan Button Misc]
    TKGDeclare TkMan(text) "TkMan"\
        -typelist [list Clients TkMan Button Misc]\
        -label "Label text"
    TKGDeclare TkMan(imagefile) {%tkman}\
        -typelist [list Clients TkMan Button Misc]\
        -label "Icon file"
}

proc TkManCreateWindow {} {
    if [TKGReGrid TkMan] return
    global TKG TkMan TkMan-params

    SetImage TkMan_image $TkMan(imagefile)

    set text [expr $TkMan(nolabel) ? \{\} : \"$TkMan(text)\"]
    TKGMakeButton TkMan \
        -image TkMan_image \
	-text $text \
	-balloon "Launch TkMan" \
        -foreground $TkMan(foreground) \
        -background $TkMan(background) \
        -activeforeground $TkMan(activeforeground) \
        -activebackground $TkMan(activebackground) \
        -exec $TkMan(pathname) \
	-iconside $TkMan(iconside)
    bind [set TkMan-params(pathname)] <3> TkMan-goto
}

# this is activated when button 3 is hit...
#  or.. at least it SHOULD be.. <chuckle>

proc TkMan-goto {} {
    upvar #0 TkMan-params P

    if [catch "selection get" sel] {
 	TKGError "Selection not set"
 	return
    }
    set sel [string trim $sel]

# see if tkman is running.  If not, start it...

    if [catch "send tkman pid"] {
        set oldmode $P(mode)
        set oldcmd $P(exec,$oldmode)
        set P(exec,$oldmode) [list $P(exec,$oldmode) $sel]
        TKGbuttonInvoke $P(pathname)
        set P(exec,$oldmode) $oldcmd
    } else {

# if it IS running, then send a message to display a man page...

        send -async tkman manShowMan $sel
    }
}
    
DEBUG "Loaded TkMan.tcl"





