# WindowList (tkgoodstuff client)

proc WindowListDeclare {} {
    set Prefs_taborder(:Clients,WindowList) "Misc WindowButtons Icons Geometry Colors"
    set Prefs_taborder(:Clients,WindowList,WindoButtons) "Misc Colors"
    TKGDeclare FWL(icons) 1 -typelist [list Clients WindowList WindowButtons Misc]\
	-vartype boolean -label "Produce icons on the window buttons"
    TKGDeclare FWL(iconside) left -typelist [list Clients WindowList WindowButtons Misc]\
	-label "Which side of the buttons the icons go on"\
	-vartype optionMenu\
	-optionlist {left right top bottom}
    TKGDeclare FWL(defaulticon) {win.xpm}\
	-typelist [list Clients WindowList WindowButtons Misc]\
	-label "Default window button icon for open windows"
    TKGDeclare FWL(iconicicon) {iconic.xpm}\
	-typelist [list Clients WindowList WindowButtons Misc]\
	-label "Default window button icon for iconified windows"
    TKGDeclare FWL(scrollbar) 1 -typelist [list Clients WindowList Misc] -vartype boolean \
	-label "Use a scrollbar if necessary"
    TKGDeclare FWL(resize) 1 -typelist [list Clients WindowList Misc] -vartype boolean \
	-label "Shorten names before using scrollbar"
    TKGDeclare FWL(resizelen) 8 -typelist [list Clients WindowList Misc] \
	-label "Shorten names to _ characters"
    TKGDeclare FWL(fg) {$TKG(foreground)} -typelist\
	[list Clients WindowList WindowButtons Colors]\
	-label "Foreground"
    TKGDeclare FWL(bg) {$TKG(buttonbackground)}\
	-typelist [list Clients WindowList WindowButtons Colors]\
	-label "Background"
    TKGDeclare FWL(afg) {$TKG(butactiveforeground)}\
	-typelist [list Clients WindowList WindowButtons Colors]\
	-label "Active foreground"
    TKGDeclare FWL(abg) {$TKG(butactivebackground)}\
	-typelist [list Clients WindowList WindowButtons Colors]\
	-label "Background"
    TKGDeclare FWL(ifg) {$TKG(disabledforeground)}\
	-typelist [list Clients WindowList WindowButtons Colors]\
	-label "Foreground for iconified windows"
    TKGDeclare FWL(field)  "" -typelist [list Clients WindowList Misc]\
	-label "Color of background"
    TKGDeclare FWL(ignore) "" -typelist [list Clients WindowList Misc]\
	-label "Space-separated list of window names of windows to ignore"\
	-help "Wildcards like \"*\" are acceptable.  X resource class names also are matched."
    TKGDeclare FWL(openfont) {$TKG(mediumfont)} -typelist [list Clients WindowList WindowButtons Misc]\
	-label "Font on buttons for open windows."
    TKGDeclare FWL(iconicfont) {$FWL(openfont)} -typelist [list Clients WindowList WindowButtons Misc]\
	-label "Font on buttons for iconified windows."
    TKGDeclare FWL(padding) 1 -typelist [list Clients WindowList WindowButtons Misc]\
	-label "How many pixels of padding around icon and text?"
    TKGDeclare FWL(sep) 3 -typelist [list Clients WindowList WindowButtons Misc]\
	-label "How many pixels of padding between icon and text?"
    TKGDeclare FWL(nofvwmicons) 1 -typelist [list Clients WindowList Misc]\
	-label "Tell fvwm not to post icons"\
	-vartype boolean
    TKGDeclare FWL(width) "" -typelist [list Clients WindowList Geometry]\
	-label "Width in characters of WindowList field"\
	-help "Leave blank to use default (which depends on various factors)."
    TKGDeclare FWL(height) "" -typelist [list Clients WindowList Geometry]\
	-label "Height in rows of WindowList field"\
	-help "Leave blank to use default (which depends on various factors)."
    lappend FWL(editors) Emacs Nedit Xedit Lyx
    lappend FWL(shells) XTerm
    lappend FWL(mailers) Exmh Xmh XFMail MH-E*
    lappend FWL(newsreaders) Knews Xrn
    lappend FWL(browsers) Netscape Mosaic Surfit
    lappend FWL(graphics) XV* Bitmap Pixmap XPaint Gimp
    lappend FWL(filers) dsk_* Xfm XDir XFtp
    lappend FWL(manreaders) TkMan Xman
    lappend FWL(tks) *.tcl Wish* Toplevel
    set templist ""
    foreach type {
	editor shell mailer newsreader browser graphic filer manreader tk
    } {
	lappend templist [list $type $type $type.xpm]
	TKGDeclare FWL(${type}s) [set FWL(${type}s)]\
	    -typelist [list Clients WindowList Icons]\
	    -label "Names of ${type}s"
	TKGDeclare FWL(icon,${type}s) "${type}.xpm"\
	    -typelist [list Clients WindowList Icons]\
	    -label "Icon for $type applications"
	foreach name [set FWL(${type}s)] {
	    set FWL_icon($name) [set FWL(icon,${type}s)]
	}
	unset FWL(${type}s)
    }
    unset name type templist
}

proc WindowListDoOnLoad {} {
    if ![info exists Fvwm(outid)] {
	TKGError "WindowList client will not work unless 
fvwm starts tkgoodstuff as an fvwm module." exit
    }
}

proc WindowListCreateWindow {} {
    global Fvwm FWL_window FWL TKG
    global $TKG(currentpanel)-pparams

    if [info exists FWL_window] {
	TKGGrid $FWL_window expand
	return
    }
    set FWL(index) 0
    set FWL(active) {}
    set FWL_images(0) 0
    #	SetImage FWLiconicimage $FWL(iconicicon)
    set FWL_window .[string tolower $TKG(currentpanel)].fwl
    frame $FWL_window -bd 0 -highlightthickness 0
    TKGRowCol $FWL_window
    if [Empty $FWL(field)] {
	set FWL(field) $TKG(panelcolor)
    }
    text $FWL_window.windows -width 1 -height 1\
	-background $FWL(field) -cursor top_left_arrow\
	-spacing1 1 -spacing2 2\
	-font $TKG(Hugefont) -highlightthickness 0 -bd 0 \
	-takefocus 0 -state disabled
    foreach pattern {<1><Motion> <1><Leave> <Double-1>} {
	bind $FWL_window.windows $pattern {break}
    }
    grid columnconfigure $FWL_window 1 -weight 1
    grid columnconfigure $FWL_window 0 -weight 0
    grid $FWL_window.windows -sticky nsew -row 0 -column 1
    switch -regexp [set $TKG(currentpanel)-pparams(screenedge)] {
	"no" {
	    set FWL(orientation) \
		[set $TKG(currentpanel)-pparams(orientation)]
	    if {$FWL(orientation) == "vertical"} {
		if [Empty $FWL(height)] {
		    TKGSet FWL(height) 10
		}
		$FWL_window.windows configure -height [expr $FWL(height) - 1]
	    } else {
		if [Empty $FWL(width)] {
		    TKGSet FWL(width) 50
		}
		$FWL_window.windows configure -width $FWL(width)
	    }
	} left|right {
	    set FWL(orientation) vertical
	} default {
	    set FWL(orientation) horizontal
	}
    }

    TKGGrid $FWL_window expand -nosep

    TKGAddToHook TKG_postedhook-$TKG(currentpanel) \
	"TKGAddToHook Fvwm_WindowName_hook FWLWindowName"\
	"TKGAddToHook Fvwm_IconName_hook FWLIconName"\
	"TKGAddToHook Fvwm_DestroyWindow_hook FWLDestroyWindow"\
	"TKGAddToHook Fvwm_Iconify_hook FWLIconify"\
	"TKGAddToHook Fvwm_Deiconify_hook FWLDeiconify"\
	"TKGAddToHook Fvwm_FocusChange_hook FWLFocusChange"\
	"fvwm send $Fvwm(outid) Send_WindowList"

    if $FWL(nofvwmicons) {
	fvwm send $Fvwm(outid) {Style "*" NoIcon}
    }

    bind $FWL_window.windows <3> {
	TKGPopupPost .tkgpopup %X %Y
	focus .tkgpopup
	grab set -global .tkgpopup
    }
}

proc FWLResize {} {
    global FvwmW FWLidarray FWL
    for { set x 0 } {$x < $FWL(index) } { incr x } {
	set id $FWLidarray($x)
	if {$FWL(active) != $FvwmW($id,pathname)} { 
	    if !$FvwmW($id,iconic) {
		global FWL${id}-params
		TKGButton FWL$id -mode resized
		FWLBind $id
	    }
	}
    }
}

proc FWLScrollbarTest {} {
    global FWL_window
    update idletasks
    set w $FWL_window.windows
    if [catch {set bb1 [$w bbox button.first]}] {return 0}
    set bb2 [$w bbox "button.last - 1 chars"] 
    if {[llength $bb1] * [llength $bb2] == 0} {return 1}
    set h1 [lindex $bb1 3]
    set bh1 [winfo reqheight [$w window cget button.first -window]]
    set h2 [lindex $bb2 3]
    set bh2 [winfo reqheight [$w window cget "button.last - 1 chars" -window]]
    expr ($h1 < $bh1 - 5) || ($h2 < $bh2 - 5)
}

proc FWLScrollbarCreate {} {
    global FWL FWL_window
    set w $FWL_window.windows
    if ![winfo exists $FWL_window.scrollbar ] {
	set topw [winfo toplevel $FWL_window]
	set wx [winfo width $topw]
	set wy [winfo height $topw]
	scrollbar $FWL_window.scrollbar -command "$w yview"\
		-highlightthickness 0 -relief flat\
		-borderwidth 0 -elementborderwidth 2 -width 10\
		-troughcolor $FWL(field)
	grid $FWL_window.scrollbar -sticky wnse -row 0 -column 0
	$w configure -yscrollcommand "$FWL_window.scrollbar set" 
	wm geometry $topw [set wx]x[set wy]
    }
}

proc FWLScrollbarDestroy {} {
    global FWL_window
    set w $FWL_window.windows
    if [winfo exists $FWL_window.scrollbar] {
	set x [winfo width .]
	set y [winfo height .]
	$w configure -yscrollcommand "" 
	destroy $FWL_window.scrollbar
	wm geometry . [set x]x[set y]
    }
}

proc FWLScrollbar {} {
    global FWL FWL_window
    if {!$FWL(scrollbar) && !$FWL(resize)} return
    set w $FWL_window.windows
    if [FWLScrollbarTest] {
	if $FWL(resize) {
	    FWLResize
	    if [FWLScrollbarTest] {
		FWLScrollbarCreate
	    }
	} else {
	    FWLScrollbarCreate
	}
    } else FWLScrollbarDestroy
}    

proc FWLPopup {x y} {
    .fvwmwinlist delete 0 end
    fvwm send 0 Send_WindowList
    flush stdout
    TKGPopupPost .fvwmwinlist $x $y
}

#Code for dragging windows onto pages in the Pager client
proc FWLButton2 {id} {
    global FvwmW
    $FvwmW($id,pathname) configure -cursor crosshair
}

# Deiconify if necessary, go to new page, move window to current
# page with same page position, and focus if not MouseFocus.
proc FWLButtonRelease2 {id x y} {
    global FvwmW Fvwm
    $FvwmW($id,pathname) configure -cursor top_left_arrow
    set w [winfo containing $x $y]
    if ![regexp {\.page\((.*),(.*),(.*)\)} $w v D X Y] return
    fvwm send $id "Iconify -1"
    fvwm send $Fvwm(outid) "Desk 0 $D"
    fvwm send $Fvwm(outid) "GotoPage $X $Y"
    fvwm send $id "WindowsDesk $D"
    set wx [expr $FvwmW($id,x) % [winfo vrootwidth .]]p
    set wy [expr $FvwmW($id,y) % [winfo vrootheight .]]p
    fvwm send $id "Move $wx $wy"
    fvwm send $id {Raise ""}
    if {$FvwmW($id,flags) & 3072} {
	fvwm send $id "Focus"
    }
}

# Get image appropriate to window name
proc FWLGetImage {id} {
    global FWL FWL_icon FWL_images FvwmW
    set name $FvwmW($id,windowname)
    set resclass $FvwmW($id,resclass)
    foreach type {name resclass} {
	foreach n [array names FWL_icon] {
	    if [string match $n [set $type]] {
		set f $FWL_icon($n)
		break
	    }
	}
    }
    if ![info exists f] {
	set f $FWL(defaulticon)
    }
    if [info exists FWL_images($f)] {
	return $FWL_images($f)
    } else {
	set i 0
	while {[lsearch [image names] "image$i"] != -1} {incr i}
	SetImage image$i $f
	set FWL_images($f) image$i
	return image$i
    }
}

proc FWLDefaultsArray {} {
    global FWL
    return [list \
		modes {normal iconic resized}\
		foreground,normal $FWL(fg)\
		background,normal $FWL(bg)\
		activeforeground,normal $FWL(afg)\
		activebackground,normal $FWL(abg)\
		font,normal $FWL(openfont)\
		padding $FWL(padding)\
		sep $FWL(sep)\
		ignore 1\
		foreground,iconic $FWL(ifg)\
		background,iconic $FWL(bg)\
		activeforeground,iconic $FWL(ifg)\
		activebackground,iconic $FWL(abg)\
		font,iconic $FWL(iconicfont)\
	       ]
    # had also had image,iconic FWL(iconicimage)
}

# Make button and put it in text widget
proc FWLCreateButton {id} {
    global FvwmW FWLindices FWL FWLidarray FWL${id}-params\
	FWL_window
    set FvwmW($id,ignored) 0
    array set FWL${id}-params [FWLDefaultsArray]
    set FvwmW($id,pathname) \
	[TKGButton FWL$id -pathname $FWL_window.windows.l$FWL(index)]
    FWLBind $id
    set FvwmW($id,iconic) 0
    $FWL_window.windows window create 1.$FWL(index) -window $FvwmW($id,pathname)\
	-padx 2 
    $FWL_window.windows tag add button 1.$FWL(index)
    $FWL_window.windows configure -state disabled
    set FWLindices($id) $FWL(index)
    set FWLidarray($FWL(index)) $id
    incr FWL(index)
}

proc FWLBind {id} {
    global FvwmW
    bind $FvwmW($id,pathname) <1> "FvwmGoto $id ; break"
    bind $FvwmW($id,pathname) <ButtonRelease-1> {break}
    bind $FvwmW($id,pathname) <2> "FWLButton2 $id ; break"
    bind $FvwmW($id,pathname) <ButtonRelease-2> "FWLButtonRelease2 $id %X %Y; break"
}

proc FWLignored {id} {
    global FWL FvwmW
    set wname $FvwmW($id,windowname)
    set resclass $FvwmW($id,resclass)
    foreach pattern [concat $FWL(ignore) tkgoodstuff tkgsrc] {
	if {[string match $pattern $wname] ||\
		[string match $pattern $resclass]} {
	    return 1
	}
    }
    return 0
}

proc FWLWindowName {id} {
    global FvwmW FWL_icons FWL FWLindices FWLwname FWL_window
    upvar \#0 FWL${id}-params P
    set name $FvwmW($id,windowname)
    if {[info exists FWLwname($id)] && ($FWLwname($id) == $name)} return
    set FWLwname($id) $name
    if ![info exists P(text,iconic)] {
	vwait FWL${id}-params(text,iconic)
    }
    if ![info exists FvwmW($id,resclass)] {
	vwait FvwmW($id,resclass)
    }
    if {([info exists FvwmW($id,ignored)] && $FvwmW($id,ignored))} return
    if [FWLignored $id] {
	set FvwmW($id,ignored) 1
	catch {$FWL_window.windows tag remove button 1.$FWLindices($id)}
	catch {destroy $FvwmW($id,pathname)}
	return
    }

    set P(text,normal) $name
    set P(balloon,normal) $name
    set P(balloon,iconic) $name
    if $FWL(icons) {
	set P(iconside) $FWL(iconside) 
	set P(image,normal) [FWLGetImage $id]
	set P(image,iconic) $P(image,normal)
    }

    if {![info exists FvwmW($id,pathname)] 
	|| ![winfo exists $FvwmW($id,pathname)]} {
	FWLCreateButton $id
    } else {
	# update the tkgbutton
	TKGButton FWL$id
    }

    TKGButtonCopyMode FWL$id normal resized
    set P(text,resized) [FWLAbbrev $name $FWL(resizelen)]

    FWLScrollbar
    bind $FvwmW($id,pathname) <3> "fvwm send $id \"Iconify\"; break"
    FWLBind $id
}

proc FWLIconName {id} {
    global FvwmW FWL${id}-params FWL
    set FWL${id}-params(text,iconic) \
	[FWLAbbrev $FvwmW($id,iconname) FWL(resizelen)]
}

proc FWLAbbrev {name len} {
    if {[set l [string length $name]] <= $len} {return $name}
    join [list [string range $name 0 [expr $len - 3]] ..] ""
}

proc FWLDestroyWindow {id} {
    global FvwmW FWLindices FWL FWLwname FWLidarray FWL_window
    catch {unset FWLwname($id)}
    catch {unset FvwmW($id,ignored)}
    if ![info exists FWLindices($id)] return
    catch {$FWL_window.windows tag remove button 1.$FWLindices($id)}
    catch {destroy $FvwmW($id,pathname)}
    $FWL_window.windows see 1.0
    for {set x $FWLindices($id)} {$x < [expr $FWL(index) - 1]} {incr x} {
	set FWLidarray($x) $FWLidarray([expr $x + 1])
    }
    catch {unset $FWLidarray($x)}
    FWLScrollbar
    set FWLactive ""
}

proc FWLIconify {id} {
    global FvwmW
    if [info exists FvwmW($id,pathname)] {
	global  FWL${id}-params
	TKGButton FWL$id -mode iconic
	FWLBind $id
    }
}

proc FWLDeiconify {id} {
    global FvwmW
    if [info exists FvwmW($id,pathname)] {
	TKGButton FWL$id -mode normal
	FWLBind $id
    }
    FWLScrollbar
}

proc FWLFocusChange {id} {
    global FvwmW FWL FWL$id-params
    if {$FWL(active)!=""} {
	catch {$FWL(active) configure -relief raised}
    }
    if {[info exists FvwmW($id,pathname)] && [winfo exists $FvwmW($id,pathname)]} {
	set FWL(active) $FvwmW($id,pathname)
	$FWL(active) configure -relief sunken
    } else {
	set FWL(active) ""
    }
}

DEBUG "Loaded WindowList"
