proc TKGBalloonBind {w text} {
    global TKG
    if ![info exists TKG(balloontext,$w)] {
	bind $w <Enter> +[list after 1000 [list TKGDoBalloon %W]]
	bind $w <Leave> +[list after cancel [list TKGDoBalloon %W]]
	bind $w <1> +[list after cancel [list TKGDoBalloon %W]]
    }
    set TKG(balloontext,$w) $text    
}

proc TKGDoBalloon {w} {
    global TKG
    if {$TKG(balloons) != 1} return
    if [string match $TKG(currentBalloon) $w] return
    if ![Empty $TKG(currentBalloon)] TKGPopBalloon
    if ![string match $w* [eval winfo containing [winfo pointerxy .]]] {
	return
    }
    set TKG(currentBalloon) $w
    set text $TKG(balloontext,$w)
    set top .tkgballoon
    toplevel $top -class Tkgoodstuff
    wm withdraw $top
    wm overrideredirect $top 1
    bind $top <1> "TKGPopBalloon"
    grid [label $top.lab -text $text -bg $TKG(balloonbackground) \
	      -borderwidth 2 -relief ridge]
    regexp {^\.([^\.]*-panel)} $w panel panel
    upvar \#0 $panel-pparams P
    update idletasks
    set x [winfo rootx $w]
    set y [expr [winfo rooty $w] - [winfo reqheight $top]]
    if {$y < 0} {
	set y [expr [winfo rooty $w] + [winfo height $w]]
    }
    if {([winfo vrootwidth .] - $x - [winfo reqwidth $top]) < 0} {
	set x [expr [winfo vrootwidth .] - [winfo reqwidth $top]]
    }
    if {([winfo vrootheight .] - $y - [winfo reqheight $top]) < 0} {
	set y [expr [winfo vrootheight .] - [winfo reqheight $top]]
    }
    wm geometry $top +${x}+${y}
    wm deiconify $top
    # in fvwm I get the panel occluding the balloon sometimes:
    after 30 "catch \"raise $top\""
    after 1500 TKGPopBalloon
}

proc TKGPopBalloon {} {
    global TKG
    if ![Empty TKG(currentBalloon)] {
	after cancel TKGPopBalloon
	destroy .tkgballoon
	set TKG(currentBalloon) ""
    }
}
