proc TKGDeclare {var default args} {
    global $var TKGVars TKGVarnames TKGTypes
    set TKGVarnames($var) 1
    for {set i 0} {$i < [llength $args]} {incr i} {
	if [regexp -- -(.*) [lindex $args $i] switch switch] {
	    set TKGVars($var,$switch) [lindex $args [incr i]]
	}
    }
    set TKGVars($var,default) $default
    if ![info exists TKGVars($var,current)] {
	TKGSet $var $TKGVars($var,default)
    }
    if ![info exists TKGVars($var,typelist)] {
	set TKGVars($var,typelist) {}
    }
    lappend TKGTypes([join $TKGVars($var,typelist) ,]) $var
    if ![info exists TKGVars($var,vartype)] {
	set TKGVars($var,vartype) entry
    }
    if ![info exists TKGVars($var,label)] {
	set TKGVars($var,label) $var
    }
    if ![info exists TKGVars($var,help)] {
	set TKGVars($var,help) ""
    }
}

proc TKGSet {var val} {
    global TKGVars $var
    set TKGVars($var,current) $val
    if [catch {set upval [uplevel \#0 [list subst $val]]} err] {
	# maybe we're referencing a variable that's not defined yet
	TKGAddToHook TKGSetHook [list TKGSet $var $val]
    } else {
	uplevel \#0 [list set $var $upval]
    }
}

set Prefs_taborder(:) "Configuration General Geometry Buttons"
set Prefs_taborder(:General) "Misc Colors Fonts Directories Debugging Fvwm"
set Prefs_taborder(:General,Colors) "MainColors MoreColors StillMoreColors"
set Prefs_taborder(:General,Fonts) "Main ResourceFonts"


set Prefs_typecomment(:Configuration) \
    "NOTE: tkgoodstuff must be restarted for (saved) preference changes to take effect."
set Prefs_typelabel(Geometry) "Screen Geometry"
TKGDeclare TKG(screenedge) no \
    -typelist Geometry\
    -label "Screen-Edge Mode" \
    -help "Span a side of the screen?"\
    -vartype optionMenu \
    -optionlist {no left right top bottom}
TKGDeclare TKG(automin) 0 \
    -typelist Geometry\
    -label "Auto-minimize" \
    -help "If screen-edge mode is not \"no\", when the cursor leaves tkgoodstuff,\
tkgoodstuff becomes a line on the screen edge (enter that line to resume)."\
    -vartype boolean
TKGDeclare TKG(geometry) -5+2\
    -typelist Geometry\
    -label "Main Panel Position\n(if not in screen-edge mode)"\
    -help "Takes an XY screen position specification like -2+200, where \"+\" means\
from the left or top, and \"-\" means from the right or bottom."
TKGDeclare TKG(orientation) vertical\
    -typelist Geometry\
    -label "Orientation"\
    -help "Main panel orientation (if not in screen-edge mode)."\
    -vartype optionMenu\
    -optionlist {horizontal vertical}
TKGDeclare TKG(icons) {$TKG(libdir)/icons:/usr/include/X11/pixmaps}\
    -typelist [list General Directories]\
    -scrollbar 1\
    -label "Directories for Icon files"\
    -help "Takes a colon-separated list of directory names."
TKGDeclare TKG(tmpdir) /tmp\
    -typelist [list General Directories]\
    -label "Directory for temporary files"
TKGDeclare TKG(xtraauto) ""\
    -typelist [list General Directories]\
    -label "Additional tcl code directories"\
    -help "The directories in this space-separated list are prepended
to auto_path, which means that tcl procedures listed in the
tclIndex files in these directories can be used in user-defined
buttons and menu items, and that you can replace tkgoodstuff
procedures with your own."

set Prefs_typelabel(General) "General Options"
TKGDeclare TKG(fontscale) 1\
    -typelist [list General Misc]\
    -vartype radio -radioside left\
    -label {Size of fonts}\
    -radiolist {{Small 0} {Large 1}}
TKGDeclare TKG(iconscale) ""\
    -typelist [list General Misc]\
    -vartype radio -radioside left\
    -label {Size of icons}\
    -radiolist {{Small "-sm"} {Large ""}}
TKGDeclare TKG(labelsonly) 0\
    -typelist {Buttons}\
    -vartype boolean\
    -label {Omit icons on buttons}
TKGDeclare TKG(iconsonly) 0\
    -typelist {Buttons}\
    -vartype boolean\
    -label {Omit text on buttons}
TKGDeclare TKG(iconside) ""\
    -typelist {Buttons}\
    -vartype optionMenu\
    -label {On which side is the icon?}\
    -help {Leave unset to use the default, which depends on various factors.}\
    -optionlist {left right top bottom}
TKGDeclare TKG(balloons) 1\
    -typelist [list General Misc] -vartype boolean\
    -label {Produce help "balloons"}
TKGDeclare TKG(borderwidth) 2\
    -typelist [list General Misc]\
    -label {Width (in pixels) of the panel border}
TKGDeclare TKG(padding) 2\
    -typelist {Buttons}\
    -label {Padding (in pixels) surrounding image and/or text.}
TKGDeclare TKG(sep) 2\
    -typelist {Buttons}\
    -label {Padding (in pixels) between image and text.}
TKGDeclare TKG(nobeep) 0\
    -typelist [list General Misc]\
    -vartype boolean\
    -label {Don't Ever Beep}
set TKG(nonotices) 0
TKGDeclare TKG(browser) netscape\
    -typelist [list General Misc]\
    -label {Default web browser for various purposes}
TKGDeclare TKG(webpage) "http://www-personal.umich.edu/~markcrim/tkgoodstuff"\
    -typelist [list General Misc]\
    -label {tkgoodstuff Home Page}
TKGDeclare TKG(internallogging) 0\
    -vartype boolean\
    -typelist {General Debugging}\
    -label "Keep an internal log"
TKGDeclare TKG(filelogging) 0\
    -vartype boolean\
    -typelist {General Debugging}\
    -label "Log to a file"
TKGDeclare TKG(logfile) {$TKG(tmpdir)/tkglog}\
    -typelist {General Debugging}\
    -label "Log to what file?"
TKGDeclare TKG(dialogtextwidth) 80 -typelist [list General Misc]\
    -label "Width in characters of text windows in dialogs."
TKGDeclare TKG(dialogtextheight) 20 -typelist [list General Misc]\
    -label "Height in rows of text windows in dialogs."

TKGSet TKG(config) \
{Client Clock
Client WWW
Client Biff
PanelButton Utilities
Client Menu
Panel Utilities
Client Webster
Client Jots
Client Calc
EndPanel
}

TKGDeclare TKG(config) $TKG(config) -typelist "Configuration"\
    -nodefault 1\
    -nolabel 1\
    -vartype config\
    -help {Here you list what you want in your tkgoodstuff panel.

Click mouse button 3 over any item for a menu of commands, including
a command to insert a new item.

Mouse button 1 can be used to select an item, and then to move it
from one place to another.  Double-clicking on an item selects a
"property sheet" for configuring the item.
    }

proc TKGDefaults {} {uplevel {
    set Prefs_typelabel(MainColors) "Main Colors"
    set Prefs_typelabel(MoreColors) "More Colors"
    set Prefs_typecomment(:General,Colors,MoreColors) \
	"Most of these by default are set automatically based on other colors."

    TKGDeclare TKG(panelcolor) \#b0b0b0 \
	-typelist [list General Colors MainColors] \
	-label "Background color of panel"
    TKGDeclare TKG(background) #b0b0b0\
	-typelist [list General Colors MainColors]\
	-label "Basic background color."
    TKGDeclare TKG(foreground) \#000000\
	-typelist [list General Colors MainColors]\
	-label "Basic foreground color (for typefaces, etc.)"
    TKGDeclare TKG(buttonbackground) {[tkDarken $TKG(panelcolor) 85]}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(buttonforeground) {$TKG(foreground)}\
	-typelist [list General Colors MoreColors]
    set bg [winfo rgb . $TKG(background)]       
    #this stolen from palette.tcl in tk4.0
    foreach i {0 1 2} {
	set light($i) [expr [lindex $bg $i]/256]
	set inc1 [expr ($light($i)*15)/100]
	set inc2 [expr (255-$light($i))/3]
	if {$inc1 > $inc2} {
	    incr light($i) $inc1
	} else {
	    incr light($i) $inc2
	}
	if {$light($i) > 255} {
	    set light($i) 255
	}
    }
    TKGDeclare TKG(activebackground) {[format #%02x%02x%02x $light(0) $light(1) $light(2)]}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(activeforeground) {$TKG(buttonforeground)}\
	-typelist [list General Colors MoreColors]
    set bg [winfo rgb . $TKG(panelcolor)]       
    #this stolen from palette.tcl in tk4.0
    foreach i {0 1 2} {
	set light($i) [expr [lindex $bg $i]/256]
	set inc1 [expr ($light($i)*15)/100]
	set inc2 [expr (255-$light($i))/3]
	if {$inc1 > $inc2} {
	    incr light($i) $inc1
	} else {
	    incr light($i) $inc2
	}
	if {$light($i) > 255} {
	    set light($i) 255
	}
    }
    TKGDeclare TKG(butactivebackground) {[format #%02x%02x%02x $light(0) $light(1) $light(2)]}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(butactiveforeground) {$TKG(buttonforeground)}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(highlightcolor) {$TKG(activeforeground)}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(labelboxbackground) {[tkDarken $TKG(panelcolor) 115]}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(textbackground) {[tkDarken $TKG(background) 115]}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(textforeground) {$TKG(foreground)}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(labelboxforeground) {$TKG(foreground)}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(disabledforeground) {[tkDarken $TKG(buttonbackground) 50]}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(menutitleforeground) {#ce0000}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(noticetitleforeground) {#ce0000}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(scrollbartrough) {[tkDarken $TKG(background) 115]}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(entrybackground) {$TKG(textbackground)}\
	-typelist [list General Colors MoreColors]
    TKGDeclare TKG(balloonbackground) {#ffcf30}\
	-typelist [list General Colors MoreColors]
    set Prefs_typecomment(:Fonts,Main) \
	"By default these are set to values of the Resource Fonts"
    set Prefs_typecomment(:Fonts,ResourceFonts) \
	"If left blank these are set to values depending on the chosen font scale"
    set Prefs_typelabel(ResourceFonts) "Resource Fonts"
    proc TKGfontset {var val1 val2} {
	global $var TKG
	TKGDeclare $var "" -typelist [list General Fonts ResourceFonts]
	if {[info exists $var] && [Empty [set $var]]} {
	    if $TKG(fontscale) {
		set $var $val1
	    } else {
		set $var $val2
	    }
	}
    }
    TKGfontset TKG(smallfont) "-*-Helvetica-medium-r-*-*-10-*-*-*-*-*-*-*"\
	"-*-Helvetica-medium-r-*-*-8-*-*-*-*-*-*-*"
    TKGfontset TKG(smallboldfont) "-*-Helvetica-bold-r-*-*-10-*-*-*-*-*-*-*"\
	"-*-Helvetica-bold-r-*-*-8-*-*-*-*-*-*-*"
    TKGfontset TKG(smallitalfont) "-*-Helvetica-medium-o-*-*-10-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-o-*-*-8-*-*-*-*-*-*-*"
    TKGfontset TKG(smallitalboldfont) "-*-Helvetica-bold-o-*-*-10-*-*-*-*-*-*-*"\
	"-*-Helvetica-bold-o-*-*-8-*-*-*-*-*-*-*"
    TKGfontset TKG(mediumfont) "-*-Helvetica-medium-r-*-*-12-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-r-*-*-10-*-*-*-*-*-*-*"
    TKGfontset TKG(mediumboldfont) "-*-Helvetica-bold-r-*-*-12-*-*-*-*-*-*-*"\
	"-*-Helvetica-bold-r-*-*-10-*-*-*-*-*-*-*"
    TKGfontset TKG(mediumitalfont) "-*-Helvetica-medium-o-*-*-12-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-o-*-*-10-*-*-*-*-*-*-*"
    TKGfontset TKG(mediumitalboldfont) "-*-Helvetica-bold-o-*-*-12-*-*-*-*-*-*-*" \
	"-*-Helvetica-bold-o-*-*-10-*-*-*-*-*-*-*"
    TKGfontset TKG(bigfont) "-*-Helvetica-medium-r-*-*-14-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-r-*-*-12-*-*-*-*-*-*-*"
    TKGfontset TKG(bigboldfont) "-*-Helvetica-bold-r-*-*-14-*-*-*-*-*-*-*" \
	"-*-Helvetica-bold-r-*-*-12-*-*-*-*-*-*-*"
    TKGfontset TKG(bigitalfont) "-*-Helvetica-medium-o-*-*-14-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-o-*-*-12-*-*-*-*-*-*-*"
    TKGfontset TKG(bigitalboldfont) "-*-Helvetica-bold-o-*-*-14-*-*-*-*-*-*-*" \
	"-*-Helvetica-bold-o-*-*-12-*-*-*-*-*-*-*"
    TKGfontset TKG(hugefont) "-*-Helvetica-medium-r-*-*-16-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-r-*-*-14-*-*-*-*-*-*-*"
    TKGfontset TKG(hugeboldfont) "-*-Helvetica-bold-r-*-*-16-*-*-*-*-*-*-*" \
	"-*-Helvetica-bold-r-*-*-14-*-*-*-*-*-*-*"
    TKGfontset TKG(hugeitalfont) "-*-Helvetica-medium-o-*-*-16-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-o-*-*-14-*-*-*-*-*-*-*"
    TKGfontset TKG(hugeitalboldfont) "-*-Helvetica-bold-o-*-*-16-*-*-*-*-*-*-*" \
	"-*-Helvetica-bold-o-*-*-14-*-*-*-*-*-*-*"
    TKGfontset TKG(Hugefont) "-*-Helvetica-medium-r-*-*-18-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-r-*-*-16-*-*-*-*-*-*-*"
    TKGfontset TKG(Hugeboldfont) "-*-Helvetica-bold-r-*-*-18-*-*-*-*-*-*-*" \
	"-*-Helvetica-bold-r-*-*-16-*-*-*-*-*-*-*"
    TKGfontset TKG(Hugeitalfont) "-*-Helvetica-medium-o-*-*-18-*-*-*-*-*-*-*" \
	"-*-Helvetica-medium-o-*-*-16-*-*-*-*-*-*-*"
    TKGfontset TKG(Hugeitalboldfont) "-*-Helvetica-bold-o-*-*-18-*-*-*-*-*-*-*" \
	"-*-Helvetica-bold-o-*-*-16-*-*-*-*-*-*-*"
    TKGfontset TKG(fixedfont) "-*-Courier-medium-r-*-*-16-*-*-*-*-*-*-*"\
	"-*-Courier-medium-r-*-*-14-*-*-*-*-*-*-*"
    TKGDeclare TKG(generalfont)   {$TKG(bigfont)}\
	-typelist [list General Fonts Main]\
	-label "Main All-Purpose Font"
    TKGDeclare TKG(combofont)     {$TKG(mediumfont)}\
	-typelist [list General Fonts Main]\
	-label "Font on Buttons with Icons"
    TKGDeclare TKG(labelonlyfont) {$TKG(bigfont)}\
	-typelist [list General Fonts Main]\
	-label "Font on Buttons without Icons"
    TKGDeclare TKG(panelbuttonfont)     {$TKG(bigboldfont)}\
	-typelist [list General Fonts Main]\
	-label "Font on PanelButtons"
    TKGDeclare TKG(menufont)      {$TKG(bigfont)}\
	-typelist [list General Fonts Main]\
	-label "Font on menus"
    TKGDeclare TKG(labelboxfont)  {$TKG(hugeboldfont)}\
	-typelist [list General Fonts Main]\
	-label "Font on Label Boxes"
    TKGDeclare TKG(dialogfont)    {$TKG(hugefont)}\
	-typelist [list General Fonts Main]\
	-label "Font in dialog boxes"
    TKGDeclare TKG(textfont)    {$TKG(hugefont)}\
	-typelist [list General Fonts Main]\
	-label "Font in screens of text"
    TKGDeclare TKG(dialogtitlefont) {$TKG(Hugeboldfont)}\
	-typelist [list General Fonts Main]\
	-label "Font in Dialog Box Titles"
}}

proc TKGSetResources {} { uplevel {
    option add *background                  $TKG(background)
    option add *Button.background           $TKG(background)
    option add *Button.foreground           $TKG(foreground)
    option add *activeBackground            $TKG(activebackground)
    option add *activeForeground            $TKG(activeforeground)
    option add *Tkgbutton.activeBackground  $TKG(butactivebackground)
    option add *Tkgbutton.activeForeground  $TKG(butactiveforeground)
    option add *disabledForeground          $TKG(disabledforeground)
    option add *highlightBackground	    $TKG(background)
    option add *highlightColor              $TKG(highlightcolor)
    option add *Label.foreground	    $TKG(foreground)
    option add *image*foreground            $TKG(buttonforeground)
    option add *image.background            $TKG(buttonbackground)
    option add *text.foreground             $TKG(textforeground)
    option add *msg.background              $TKG(labelboxbackground)
    option add *msg.foreground              $TKG(labelboxforeground)
    option add *text.background             $TKG(textbackground)
    option add *Scrollbar.troughColor       $TKG(scrollbartrough)
    option add *Entry.background            $TKG(entrybackground)

    option add *font             $TKG(generalfont)   widgetDefault
    option add *Menu*font        $TKG(menufont)      widgetDefault
    option add *lbtext.font      $TKG(labelboxfont)  widgetDefault
    option add *view.text.font   $TKG(textfont)      widgetDefault
    option add *message.font     $TKG(dialogfont)    widgetDefault
    option add *title.title.font $TKG(dialogtitlefont) widgetDefault
}}
