#------------------------------------------------------------------------
#
#  mkShowInfoClients.tcl ---
#  
#  Part of the Whiteboard application. It shows client information.
#  
#  The whiteboard application has been developed by:
#  
#	Mats Bengtsson, 
#	Hamngatan 21,
#	SE-58226, Linkoping Sweden,
#	matben@lin.foa.se,
#	phone: +46 13 136114
# 
#  It is distributed under the standard GPL.
#  See the README file for further details.
#  
#------------------------------------------------------------------------

proc mkShowInfoClients  { allIPnumsTo }  {
    global  ipNum2Socket sysFont ipNum2User ipNum2Name ipNum2ServPort
    
    if {[llength $allIPnumsTo] <= 0}  {
	return
    }
    set w .infocli
    catch {toplevel $w}
    wm title $w "Client Info"
    pack [frame $w.frall -borderwidth 1 -relief raised]
    pack [frame $w.frtop -borderwidth 0] -in $w.frall
    
    
    # Treat each connected client in order and make a labelled frame for each.
    set n 0
    foreach ip $allIPnumsTo  {
	set channel $ipNum2Socket($ip)
	set peername [fconfigure $channel -peername]
	set sockname [fconfigure $channel -sockname]
	set buff [fconfigure $channel -buffering]
	set block [fconfigure $channel -blocking]
	pack [frame $w.frtop$n -borderwidth 0] -in $w.frtop
	set wcont [LabeledFrame $w.frtop$n [lindex $peername 1]]
	# Frame for everything inside the labeled container.
	set fr [frame $wcont.fr]
	label $fr.a1 -text "IP number:" -font $sysFont(sb)
	label $fr.a2 -text "[lindex $peername 0]" -font $sysFont(s)
	label $fr.b1 -text "Host name:" -font $sysFont(sb)
	label $fr.b2 -text "[lindex $peername 1]" -font $sysFont(s)
	label $fr.c1 -text "User name:" -font $sysFont(sb)
	label $fr.c2 -text $ipNum2User($ip) -font $sysFont(s)
	label $fr.d1 -text "Port number:" -font $sysFont(sb)
	label $fr.d2 -text "$ipNum2ServPort($ip)" -font $sysFont(s)
	label $fr.e1 -text "Buffering:" -font $sysFont(sb)
	label $fr.e2 -text "$buff" -font $sysFont(s)
	label $fr.f1 -text "Blocking:" -font $sysFont(sb)
	label $fr.f2 -text "$block" -font $sysFont(s)
	grid $fr.a1 -column 0 -row 0 -sticky e
	grid $fr.a2 -column 1 -row 0 -sticky w
	grid $fr.b1 -column 0 -row 1 -sticky e
	grid $fr.b2 -column 1 -row 1 -sticky w
	grid $fr.c1 -column 0 -row 2 -sticky e
	grid $fr.c2 -column 1 -row 2 -sticky w
	grid $fr.d1 -column 0 -row 3 -sticky e
	grid $fr.d2 -column 1 -row 3 -sticky w
	grid $fr.e1 -column 0 -row 4 -sticky e
	grid $fr.e2 -column 1 -row 4 -sticky w
	grid $fr.f1 -column 0 -row 5 -sticky e
	grid $fr.f2 -column 1 -row 5 -sticky w
	pack $fr -side left -padx 20
	pack $wcont -fill x    
	incr n
    }
    # button part
    pack [frame $w.frbot -borderwidth 0] -in $w.frall -fill both  \
      -padx 8 -pady 6
    pack [button $w.ok -text "  OK  " -default active -command "destroy $w"]  \
      -in $w.frbot -side right -padx 5 -pady 5
    wm resizable $w 0 0
    bind $w <Return> "$w.ok invoke"

    tkwait window $w
    grab release $w
}
#---------------------------------------------------------------------
