# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: modules.tcl,v 1.3 1999/01/11 20:50:37 jfontain Exp $}

class modules {

    set modules::(all) {}

    proc modules {this} error                                                                                   ;# object-less class

    proc printAvailable {} {            ;# using Tcl built-in package management facilities, seek and print available moodss modules
        catch {package require {}}                                              ;# make sure Tcl package auto loading search is done
        foreach package [package names] {
            if {[catch {package require $package}]||![info exists ::${package}::data(updates)]} continue  ;# ignore invalid packages
            puts -nonewline "$package: possibly in"
            set count 0
            foreach directory $::auto_path {
                if {[file readable [file join $directory $package pkgIndex.tcl]]} {
                    if {$count>0} {
                        puts -nonewline ,
                    }
                    puts -nonewline " [file join $directory $package]"
                    incr count
                }
            }
            puts {}
        }
    }

    # recursive procedure: eventually initialize next module and its eventual options in command line arguments
    proc initializeNext {arguments} {         ;# arguments list format is: module [-option [value] -option ...] module [-option ...]
        if {[llength $arguments]==0} return                                                                         ;# nothing to do
        set module [lindex $arguments 0]
        set arguments [lrange $arguments 1 end]                                         ;# point to start of switches or next module
        if {[lsearch -exact $modules::(all) $module]>=0} {
            puts stderr "$::argv0: module \"$module\" was specified more than once"
            exit 1
        }
        package require $module                                                                             ;# module is loaded here
        lappend modules::(all) $module                           ;# we never get here if there is an error when the module is loaded
        set initialize [expr {[string length [namespace eval ::$module {info proc initialize}]]>0}]
        if {[catch {set ::${module}::data(switches)} switches]} {                                         ;# module takes no options
            if {$initialize} {
                ::${module}::initialize                                                 ;# let module initialize self if it needs to
            }
            set modules::($module,arguments) {}                                 ;# save module arguments for eventual saving in file
        } else {                                                                                             ;# module takes options
            if {[llength $switches]==0} {
                puts stderr "module \"$module\" switches are empty"
                exit 1
            }
            if {[catch {set next [parseCommandLineArguments $switches $arguments options]} message]}  {
                puts stderr "module \"$module\" options error: $message"
                exit 1
            }
            if {!$initialize} {
                puts stderr "module \"$module\" has no initialize procedure"
                exit 1
            }
            ::${module}::initialize options                                                            ;# let module initialize self
            # save module arguments for eventual saving in file
            set modules::($module,arguments) [lrange $arguments 0 [expr {[llength $arguments]-[llength $next]-1}]]
            set arguments $next
        }
        initializeNext $arguments                                                                                ;# process the rest
    }

}
