# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: databar.tcl,v 1.18 1998/12/26 10:43:44 jfontain Exp $}

class dataBarChart {

    proc dataBarChart {this parentPath args} composite {
        [new barchart $parentPath\
            -title {} -bottommargin 6 -topmargin 3 -bufferelements 0 -plotborderwidth 1\
            -plotbackground $widget::(default,ButtonBackgroundColor)\
        ] $args
    } blt2DViewer {$widget::($this,path)} {
if {$::officialBLT} {
        $widget::($this,path) grid off                                                                      ;# grid is on by default
        $widget::($this,path) xaxis configure -hide 1
} else {
        $widget::($this,path) xaxis configure -mapped 0
}
        composite::complete $this
    }

    proc ~dataBarChart {this} {
        if {[string length $composite::($this,-deletecommand)]>0} {
            uplevel #0 $composite::($this,-deletecommand)                                   ;# always invoke command at global level
        }
    }

    proc options {this} {
        # force size values
        return [list\
            [list -deletecommand {} {}]\
            [list -draggable draggable Draggable 0 0]\
            [list -height height Height $configuration::(default,viewer,height)]\
            [list -mode mode Mode normal normal]\
            [list -width width Width $configuration::(default,viewer,width)]\
        ]
    }

    proc set-deletecommand {this value} {}

    foreach option {-height -width} {
        proc set$option {this value} "\$widget::(\$this,path) configure $option \$value"
    }

    proc set-draggable {this value} {
        if {$composite::($this,complete)} {
            error {option -draggable cannot be set dynamically}
        }
        if {$value} {
            blt2DViewer::allowDrag $this
        }
    }

    proc set-mode {this value} {
        $widget::($this,path) configure -barmode $value
    }

    proc newElement {this path args} {                                                          ;# invoked from 2D viewer base class
        set element [eval new element $path $args]
        element::update $element {}                                                            ;# show empty value for user feedback
        return $element
    }

    proc updateElement {this element seconds value} {
        element::update $element $value
    }

}

class dataBarChart {
    class element {

        proc element {this path args} switched {$args} {
            $path element create $this -label {} -borderwidth 1 -xdata 0              ;# use object identifier as element identifier
            set ($this,path) $path
            switched::complete $this
        }

        proc ~element {this} {
            [set ($this,path)] element delete $this
            if {[string length $switched::($this,-deletecommand)]>0} {
                uplevel #0 $switched::($this,-deletecommand)                                ;# always invoke command at global level
            }
        }

        proc options {this} {
            return [list\
                [list -color black black]\
                [list -deletecommand {} {}]\
                [list -label {} {}]\
            ]
        }

        proc set-label {this value} {
            [set ($this,path)] element configure $this -label $value
        }

        proc set-color {this value} {
            [set ($this,path)] element configure $this -foreground $value
        }

        proc set-deletecommand {this value} {}                                                   ;# data is stored at switched level

        proc update {this y} {
            if {[string length $y]==0} {                                                                       ;# handle empty value
                [set ($this,path)] element configure $this -ydata 0 -label "$switched::($this,-label): ?"
            } else {
                [set ($this,path)] element configure $this -ydata $y -label "$switched::($this,-label): $y"
            }
        }
    }
}

class dataSideBarChart {
    proc dataSideBarChart {this parentPath args} dataBarChart {$parentPath $args} {
        composite::configure $this -mode aligned
    }
    proc ~dataSideBarChart {this} {}
    proc iconData {} {
        return {
            R0lGODdhKAAoAMYAAHt5e87PzgAAANbX1v///wAIADFhITFhGAAQAK33e6X3e5znc6Xvc5zna5TXa5Tfazk4OUJJQozPY4THWnvHWoTPY3u+Wnu+UqWupQAY
            AHO2UhgQADEgAHNJAGuuShAIACkgAPffSu/XQiEYAGOmSu/PQufHOWOeQue+OVqWOda2MQAgAN6+MVKOOd62MUqGMc6mKVIIYzEIOXMQhGsQe2sYe0J5KTko
            AK0YzrUg1r0o1owQpQAoADlxKc6eIQAQEBBphBBhe944/6UYvbUYzkIoAMaWIa3X57Xf76XP594w/95B/zlpIb2OGMaeIedJ/0owAAAQGJTH3r0Y3iFREFI4
            AAAYIYy+1oS+znMoe+dR/ylZGLWGEGumvXOuxudZ/7V5EAAgKWsge+dh/9YY984Y761xCFKWrXMwe2NBAAAwQkKOpd4o/wAAAAAAAAAAAAAAAAAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAKAAoAAAH/oAAgoOEhYaHiIMBAAKNjo+QkZKTjYsCAZiZAQOYnJuanp6ao6OMAQSo
            qagAqq2sramvq6iWp7AEsrC5rqqvlgOoBQUGB8TFxbq3s7G0poIFCAnSCgoLDAeJ2YW1wQXVDODWBsnKub6MwATQ4QsLDQsH5LfmzZfdDO8N7w4Ggr3KuP4R
            qPUMwb4HCPlBiKBN2y9UCAo4eOCgogMJ/eiVE8iNAAIEFCWIFJlR4DyO6CAWGClyAoWSzDbGJAjgYwUKEyrcnGBgYcNsHSO6nGChqAWYy07OTOkRAQWjRS8g
            JYABoMaOGRBc2MpVg4ENHDqIHStWXsCBzmoi0KDBA1u3/gY+gAhBl64IER1+AsBaoG1btx4MjOAQ4q5hvGbPCUiXFfBbEl853C0xuUSHxPVsZShAorNnyINL
            iDZhooSJvBqX/RKU9YTr1ycEcyhN2gSK0z4dmkLVOsWJFL5TyLZtQoUKFChQmzzbcQUC4NCBG+DAAYUKFtivK4+pejeBFQV+twDeosV0DtddqDe+PSlzRo6y
            lp/f4sV5F8bzw+hACZKlGAA698KABNoHAgcwGAfDgip0IIMMM0RIwww0TEhDDRj+B2BWL9jg4YcG3ADCgiQu2AGAOKSIQw4stqiDDpbsICMPBXjYg402hIjg
            gj74YOIPBQARxJBEBiHEkUJY/jIEETk4Z0MPUEZpQBE7GmElDEZ08MMPRyBxxJdHJBGEEkIssYQlOBCBAw8IQMmEm0xMCYKVTTjhhBFNaMmll2CKWeYST6C5
            Io1MFGqoAQZAwYGVeDZhZQdRRBGmFJRSGoSZT5zJCA46TOEcoqAiSkUVHDRh6ql5WhEFpVe0igUWQWSRhRZaWDLFrWwiWgwxW1ChaBNcBCtsB1ZYccWrXSTr
            RaxZfPGFrVPo4NwBW1RbLRWjcsAFGNuCwW0HYUThRRfjJttFEGJkMcYYtpJRBo3YxhsvFCBsa4a3YJgBbhTmJnvGGbGisa4l7r6LgLzypsHBvfd6q68aUfwr
            8RprGgQ8MCMFF8zGxhx37PHHIHO8CCkkl2yyyYEAADs=
        }
    }
}

class dataStackedBarChart {
    proc dataStackedBarChart {this parentPath args} dataBarChart {$parentPath $args} {
        composite::configure $this -mode stacked
    }
    proc ~dataStackedBarChart {this} {}
    proc iconData {} {
        return {
            R0lGODdhKAAoAMYAAHt5e87PzgAAANbX1v///xAoCAAIADFhITFhGAAQAK33e6X3e5znc6Xvc5zna5TXa5Tfazk4OUJJQozPY4THWnvHWoTPY3u+Wnu+UlI4
            ABAIABgQADEgAHNJACkgAO/XQvffSiEYAO/PQufHOee+Oda2MSEQAN6+Md62MVIIY86mKWsQe2sYe4wQpTkoAHMoe70o1qUYvbUYzrUg1gAYIQAQEBBphBBh
            e2sge944/60Yzq3X57Xf76XP53Mwe95B/+dJ/70Y3gAQGJTH3oy+1oS+zudR/2umvXOuxudZ/9YY984Y7wAgKedh/wAoOVKWrQAwQkKOpd4o/wAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAKAAoAAAH/oAAgoOEhYaHiIMBAAKNjo+QkZKTjYsCAZiZAQOYnJuanp6ao6OMAQSo
            qagAqq2sramvq6iWp7AEsrC5rqqvlgOoBQIGxAcIxsjHysnMy7i0poLDxAkK1gsMDdYK2NrX2dvdCIS1qMTn3Q3Z6evZ6g3sDQfPBL/m5wkN6gwO7gz8/gDq
            +9cPAb1yBM4Ra9Cv3wOGAB82ZCAx4oFB9aIBUJjAIQQIDzyCFBmS4scHByJIiADAXsIEMA08APngwYSZNW3irHmTps2LgjJeQpXAAMwEICconZB0aVOlTycA
            ZeXSaMylEyhUwKqV69alWqcKXQTgKEwLFSigVZt2rdu2/nAppJQgoaUpokcNaKVwoe/evhf++k0LWGxVsxUAX8CQGDBjxY8dG75LIIMGDRs4dNjMubPnz50x
            1hK04bIGDx9AqAaRWnVr1q0/vJbdIYJtu0MJmA7BQbbv38CD/+4gmhEwAiGSZxbxgXnz58yji5AOXQTxoAiTJ+cwYvqI7967i+hOfrz38depGheknTf57+/f
            k4A/f/yI+bVX4rbVngOJ+SWU8N8IAgI4YIEGkpDeWKiYwMGDHJxQwgkUSljhhBZSOCGGEy6IEIQPTojCiCKiUGKAJJ5YgoeMOOIBiCYGWEKMM8ooI400dvCI
            JSn0COGLKgSowpBCBlkCkUQe/mmkCh2swMKTlrQgJYQueDDklVhmqSWWHbzgJQyWxCDDDDQMU4MBNtygpppprnlDm2vCuSYOXuZgiQ4y6EBMDXzuwMMOgPbg
            J6A7CPpnoIMGesMLPvjww506zLBnn4cWmqillRpKaA+LNgrEnTAEwWcNQghR6BCoDnFqqqui2uoQN9D5wqOMBGFrqTTQIASqRBBRRBG8+grsEL3+Guyvnfpg
            hCW2wpDrs8IecQQS0U5bLbW/SotEskkwq8QSTITLhBBITCutueVqa6666R4Rq5dNWPItuEw4Me65RzzxBL768rvvufomGy8j8zIBxcFC6KtvFFEo/ATDDkOs
            MMMCFlsixcUYZ6zxxhx3LMUipIQs8sgjBwIAOw==
        }
    }
}

if {$officialBLT} {

class dataOverlapBarChart {
    proc dataOverlapBarChart {this parentPath args} dataBarChart {$parentPath $args} {
        composite::configure $this -mode overlap
    }
    proc ~dataOverlapBarChart {this} {}
    proc iconData {} {
        return {
            R0lGODdhKAAoAMYAAHt5e87PzgAAANbX1v///xAoCAAIADFhITFhGAAQAK33e6X3e5znc6Xvc5zna5TXa5Tfazk4OUJJQozPY4THWnvHWoTPY3u+Wnu+UqWu
            pQAYAHO2UlI4ABAIABgQADEgAHNJAGuuSikgAPffSu/XQiEYAGOmSu/PQufHOWOeQue+OVqWOda2MQAgACEQAN6+MVKOOd62MUqGMc6mKVIIYzEIOXMQhGsQ
            e2sYe4wQpUJ5KTkoAK0YzrUg1r0o1qUYvbUYzgAoADlxKUIoAM6eIQAYIQAQEBBphBBhe944/8aWIa3X57Xf76XP594w/95B/zlpIb2OGMaeIedJ/70Y3kow
            AAAQGJTH3oy+1oS+znMoe+dR/ylZGLWGEGumvXOuxudZ/9YY984Y7yFRELV5EAAgKWsge+dh/61xCAAoOVKWrXMwe2NBAAAwQkKOpd4o/wAAAAAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAKAAoAAAH/oAAgoOEhYaHiIMBAAKNjo+QkZKTjYsCAZiZAQOYnJuanp6ao6OMAQSo
            qagAqq2sramvq6iWp7AEsrC5rqqvlgOoBQIGxAcIxsi9t7OxtKaCw8QJCtQLDA0IidqKpqjE39YNDdcHysu5vozABN8GCeIMDA4MCOa36M6X3u0N8/MPBwbh
            WjawGYFagtol+AcBAsAIEiJsQ/TLW4KLBh44fPBgQkBBBe+Zq4UqgbuLDieo9Chwl72CFdldNLlyAoUKH1m5NMgMIYCZFy1UoCCUwgGIEiYeIkkAqIGbFC5I
            zRlS10h1FmdWkCoVA9UMBPEd7EZAQwINZjGo3cChQwcP/h9AyJ0LgpdBn2jNJtiwIcQGD247iBhBeAQJEiCUMj2L1kDfvoFLfDB8+HDdl+kErGNs1m8IEyVC
            wz18gsSJE5d5wiSbV4MBE7BBh5Z8+gQK24lBVs08QFDrBCmCp5gt+TYKFCpQgIAoMdHivMBXpFhB/ANyFCxUqMj9SixTDS3AJ1hBfoWLD+g/qGDx4gV77sx6
            kk3Qor6B6TBgpEfPPkYMFizAt1s+jqAVXgL5wSCDCPv9ByALM4BAySOW0GAhePUlIMOGMqTH4AwAzgAiCDWUaMMNJ6J4Aw4sWpLDixiaJYMONKa3gwgi5hih
            hTTwwEMPQAbpgw+W/ABEDxgG/mEAjULo8MEOQ+zwQY5EFDGMEQYcgcSWXCbhZRKW8AAED+AF0UICOgih5gdRDjHlDEooQYwRdC7BxBJ4NoGEE0k88USYP2pg
            ZhAJqAkFFGwOMYQIcUYhxZx13pknEn0+MUWYPlAhaAtKHgrFAYlW8UGcSkRBpxFWWLFEE1e0egUSfk7xJyNU1CqomQkcoCuoVVTBwQdRBBtFqkUUYUWrWGCR
            RRZIaOHsFpbU6sOthOqKABcf+CpqFF10W+y3ymbhhRdfNOssGNGGIcatZ17LxRgfcCDvB12QUW8Z+JZhxRfkjusFEmY4e4Yl6q4bxMEGjKEwvNqKUC8aZOCb
            hr7+OXqhhhrNrrHGwIwUTG0CC8PLxsgfQAxxGW2kbMXFF7vhRsYbW/LGzDTXbPPNOOf8xiKk9Ozzzz8HAgA7
        }
    }
}

}
