# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: html.tcl,v 1.24 1999/01/17 20:16:16 jfontain Exp $}

# use bold and smaller sizes than the HTML library default ones for headers
array set HMtag_map {
    h1 {size 22 weight bold}
    h2 {size 20 weight bold}
    h3 {size 18 weight bold}
    h4 {size 16 weight bold}
    h5 {size 14 weight bold}
    h6 {weight bold}
}

# use a font (Helvetica instead of Times) nicer and smaller than the HTML library default one
set HMtag_map(hmstart) {
    family Helvetica  weight medium  style r  size 12
    Tcenter ""  Tlink ""  Tnowrap ""  Tunderline ""  list list
    fill 1  indent ""  counter 0  adjust 0
}

# make headers and preformatted text stand out better by adding new lines around them.
array set HMinsert_map {
    h1 \n\n /h1 \n\n h2 \n\n /h2 \n\n h3 \n\n /h3 \n\n h4 \n\n /h4 \n\n h5 \n\n /h5 \n\n h6 \n\n /h6 \n\n pre \n\n /pre \n\n
}

unset HMevents(Enter)                                                     ;# prevent links highlighting, try to behave like Netscape
unset HMevents(Leave)
unset HMevents(1)
set HMevents(ButtonRelease-1) {-foreground darkblue}

proc HMlink_callback {widget reference} {                                                          ;# supply link callback procedure
    global htmlHelpDataText

    if {![string match #* $reference]} return                                                 ;# can only handle internal references
    HMgoto $htmlHelpDataText [string trimleft $reference #]                                   ;# always update help data text widget
}

proc HMset_image {widget label source} {                                                          ;# supply image handling procedure
    if {\
        [catch {image create photo -file $source} image]&&\
        [catch {image create photo -file [file join $::widgetHTMLDirectory($widget) $source]} image]\
    } return                                                             ;# local directory and widget directory searched and failed
    bind $label <Destroy> "image delete $image"                      ;# setup binding so that image is deleted as label is destroyed
    HMgot_image $label $image                                                               ;# got the image for the specified label
}

proc customHMTLConfiguration {path} {                                             ;# make HTML text widget behave more like Netscape
    $path tag configure mark -foreground black                                                        ;# override list markers color
    $path tag configure link -borderwidth 1 -foreground blue -underline 1           ;# override hypertext links border and underline
    set ::HM${path}(S_symbols) oooooo\xd7\xb0>:\xb7                                   ;# use simple circles for list element markers
}

proc setupHelpWindow {toplevel} {
    if {[winfo exists $toplevel]} {
        wm deiconify $toplevel
        raise $toplevel
        return 0
    }
    toplevel $toplevel
    wm group $toplevel .                                             ;# for proper window manager (windowmaker for example) behavior
    return 1
}

proc generalHelpWindow {} {
    global htmlHelpDataText

    if {![setupHelpWindow .topHelp]} return
    wm title .topHelp {moodss: Global Help}
    frame .topHelp.bound                      ;# create a frame for bindings that otherwise would propagate to all toplevel children

    set panes [new panner .topHelp -panes 2]                                         ;# split window in 2 for contents and help data
    pack $widget::($panes,path) -fill both -expand 1

    set contents [new scroll text $panner::($panes,frame1) -horizontal 0 -height 100 -width 500]
    pack $widget::($contents,path) -fill both -expand 1

    set widget [new scroll text $panner::($panes,frame2) -height 400]
    pack $widget::($widget,path) -fill both -expand 1

    bind .topHelp.bound <Destroy> "delete $widget $contents $panes"

    set contentsText $composite::($contents,scrolled,path)                                       ;# first setup and display contents
    $contentsText configure -cursor watch                                                 ;# show that we are busy for user feedback
    update idletasks

    HMinit_win $contentsText
    customHMTLConfiguration $contentsText

    $contentsText configure -state normal
    HMparse_html $::htmlHelpContents "HMrender $contentsText"
    if {![winfo exists .topHelp]} return                            ;# user may have destroyed the window through the window manager
    $contentsText configure -state disabled
    HMset_state $contentsText -stop 1                                                        ;# stop rendering previous page if busy

    set htmlHelpDataText $composite::($widget,scrolled,path)                                      ;# now setup and display help text

    # use rpm documentation directory for images repository
    set ::widgetHTMLDirectory($htmlHelpDataText) /usr/doc/moodss-$::applicationVersion
    bind $htmlHelpDataText <Destroy> "unset ::widgetHTMLDirectory($htmlHelpDataText)"

    $htmlHelpDataText configure -cursor watch                                             ;# show that we are busy for user feedback
    update idletasks

    HMinit_win $htmlHelpDataText
    customHMTLConfiguration $htmlHelpDataText

    $htmlHelpDataText configure -state normal
    HMparse_html $::htmlHelpData "HMrender $htmlHelpDataText"
    if {![winfo exists .topHelp]} return                            ;# user may have destroyed the window through the window manager
    $htmlHelpDataText configure -state disabled
    HMset_state $htmlHelpDataText -stop 1                                                    ;# stop rendering previous page if busy
    focus $htmlHelpDataText                                         ;# force focus on text widget so that page up and down keys work

    $htmlHelpDataText configure -cursor {}                                      ;# show that we are no longer busy for user feedback
    $contentsText configure -cursor {}
    update idletasks
}

proc moduleHelpWindow {name} {
    global htmlHelpDataText

    ### use same toplevel as general help as we can handle only 1 widget at a time (see link callback procedure above) ###
    if {![setupHelpWindow .topHelp]} return
    wm title .topHelp "moodss: $name Module Help"
    frame .topHelp.bound                      ;# create a frame for bindings that otherwise would propagate to all toplevel children

    set widget [new scroll text .topHelp -horizontal 0]
    pack $widget::($widget,path) -fill both -expand 1

    bind .topHelp.bound <Destroy> "delete $widget"

    set htmlHelpDataText $composite::($widget,scrolled,path)                                          ;# setup and display help text

    # use module directory for images repository
    set ::widgetHTMLDirectory($htmlHelpDataText) $::packageDirectory($name)
    bind $htmlHelpDataText <Destroy> "unset ::widgetHTMLDirectory($htmlHelpDataText)"

    $htmlHelpDataText configure -cursor watch                                             ;# show that we are busy for user feedback
    update idletasks

    HMinit_win $htmlHelpDataText
    customHMTLConfiguration $htmlHelpDataText

    $htmlHelpDataText configure -state normal
    HMparse_html [modules::helpHTMLData $name] "HMrender $htmlHelpDataText"
    if {![winfo exists .topHelp]} return                            ;# user may have destroyed the window through the window manager
    $htmlHelpDataText configure -state disabled
    HMset_state $htmlHelpDataText -stop 1                                                    ;# stop rendering previous page if busy

    $htmlHelpDataText configure -cursor {}
    update idletasks
}
