# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: utility.tcl,v 1.8 1999/01/17 20:13:37 jfontain Exp $}

proc minimum {a b} {return [expr {$a<$b?$a:$b}]}
proc maximum {a b} {return [expr {$a>$b?$a:$b}]}

proc ldelete {listName value} {
    upvar $listName list

    set index [lsearch -exact $list $value]
    if {$index<0} {
        error "\"$value\" is not in list"
    }
    set list [lreplace $list $index $index]

}

proc startGatheringRCSIds {} {
    trace variable ::rcsId w recordRCSId
}

proc recordRCSId {variableName empty operation} {
    foreach {header file version} $::rcsId break
    regsub {,v$} $file {} file
    set ::sourceVersion($file) $version
}

proc commaSeparatedString {words} {
    for {set index 0} {$index<([llength $words]-1)} {incr index} {
        append string "[lindex $words $index], "
    }
    append string [lindex $words $index]
    return $string
}

proc startGatheringPackageDirectories {} {
    catch {rename source _source}
    proc source {file} {
        foreach name [package names] {
            set package($name) {}
        }
        uplevel _source [list $file]
        foreach name [package names] {                                                        ;# see what new packages are available
            if {![info exists package($name)]} {
                set ::packageDirectory($name) [file dirname $file]
            }
        }
    }
}
