class
	--
	-- Holds context that must be maintained across tcl commands
	--
	COMMAND_CONTEXT

creation
	make

feature -- Initialization
	make(interp: like tcl_interp) is
			-- create a context
		require
			valid_tcl_interp: interp /= Void and then interp.is_not_void
		do
			tcl_interp := interp
			!!song_table.make("song")
			!!annotator.make(Current)
			!!event_factory.make(annotator)
		ensure
			interp_set: tcl_interp = interp
		end

feature -- Access
	tcl_interp: POINTER
	song_table: HANDLE_TABLE[SONG]
	compatibility_mode: STRING
	annotator: ANNOTATOR
	event_factory: EVENT_FACTORY

feature -- Element Change
	set_compatibility_mode(s: STRING) is
			-- make commands compatible with an earlier tclmidi release
		do
			compatibility_mode := s
		end

invariant
	valid_interp: tcl_interp /= Void and then tcl_interp.is_not_void

end -- COMMAND_CONTEXT
