class
	--
	-- The mididelete command implementation
	--
	COMMAND_MIDI_DELETE

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "mididelete"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID track {event | in_point out_point}")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
			in_point, out_point: INTEGER
		do
			if arguments.count /= 4 and arguments.count /= 5 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end

			if not error then
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				end
			end
	
			if not error then
				-- verify valid track number
				!!track.make
				track.set_context(context)
				track.set_song(context.song_table.get(arguments.item(2)))
				track.check_track_identifier(arguments.item(3))
				if track.is_valid then
					syntax_valid := True
					error := False
				else
					syntax_valid := False
					error := True
					command_result := track.error_description
				end
			end

			-- verifying event involves parsing it.  Wait for execution.

			if arguments.count = 5 then
				-- verify in and out points
				if not arguments.item(4).is_integer then
					syntax_valid := False
					error := True
					!!command_result.copy("Invalid in point '")
					command_result.append(arguments.item(4))
					command_result.append("'")
				elseif not arguments.item(5).is_integer then
					syntax_valid := False
					error := True
					!!command_result.copy("Invalid out point '")
					command_result.append(arguments.item(5))
					command_result.append("'")
				else
					in_point := arguments.item(4).to_integer
					out_point := arguments.item(5).to_integer
					if in_point < 0 then
						error := True
						syntax_valid := False
						!!command_result.copy("In point must not be negative")
					elseif out_point <= in_point then
						error := True
						syntax_valid := False
						!!command_result.copy("Out point must be greater %
							%than in point")
					end
				end
			end
		end

	execute is
			-- execute command
		local
			song: SONG
			track_id: TRACK_NUMBER
			track: TRACK
			time, duration: INTEGER
			e: EVENT
			note_on: NOTE_ON_EVENT
			note_off: NOTE_EVENT
			note_off_time: INTEGER
			in_point, out_point: INTEGER
			complete_match: BOOLEAN
			tcl_list: TCL_LIST
			args: ARRAY[STRING]
		do
			song := context.song_table.get(arguments.item(2))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(song)
			track_id.set_track_identifier(arguments.item(3))
			track := song.track(track_id.track_number)

			if arguments.count = 5 then
				-- remove a range
				in_point := arguments.item(4).to_integer
				out_point := arguments.item(5).to_integer
				track.goto(in_point)
				track.mark_in
				track.goto(out_point)
				track.mark_out
				track.remove_range
				command_result := "1"
			else
				-- remove specific event
				!!tcl_list.make_from_list(context.tcl_interp, arguments.item(4))
				tcl_list.split
				if tcl_list.error then
					error := True
				else
					args := tcl_list.split_list

					context.event_factory.set_event_description(args)
					e := context.event_factory.create_event

					if context.event_factory.error then
						command_result :=
							context.event_factory.error_description
						error := True
					else
						if not args.item(1).is_integer then
							error := True
							!!command_result.copy("Invalid time value '")
							command_result.append(args.item(1))
							command_result.append("'")
						else
							time := args.item(1).to_integer

							if args.item(2).is_equal("Note") then
								-- We don't have matching durations
								-- unless we're in a track, which
								-- we're not, so allow sibling to
								-- be a wildcard.
								note_on ?= e
									-- must be a note on event
									check note_on /= Void end
								note_on.set_sibling_wildcard
							end

							track.find(e, time)
							if not track.found then
								command_result := "0"
							else
								complete_match := True
								-- handle NoteOn/NoteOff pair
								if args.item(2).is_equal("Note") then
									note_on ?= track.item

										-- must be a note on event
										check note_on /= Void end

									if args.item(6).same_as("*") then
										note_off := note_on.sibling
										note_off_time := time + note_on.duration
									elseif note_on.sibling = Void then
										complete_match := False
									else
										duration := args.item(6).to_integer

										if duration /= note_on.duration then
											complete_match := False
										else
											note_off := note_on.sibling
											note_off_time := time + duration
										end
									end
								end

								if complete_match then
									track.remove
									command_result := "1"

									if note_off /= Void then
										track.find(note_off, note_off_time)

											-- NoteOn sibling must be found
											check track.found end

										track.remove
									end
								else
									command_result := "0"
								end
							end
						end
					end
				end
			end
		end

end -- COMMAND_MIDI_DELETE
