class
	--
	-- The midiget command implementation
	--
	COMMAND_MIDI_GET

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midiget"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID track time|next|prev")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
			time: INTEGER
		do
			if arguments.count /= 4 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end

			if not error then
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				end
			end
	
			if not error then
				-- verify valid track number
				!!track.make
				track.set_context(context)
				track.set_song(context.song_table.get(arguments.item(2)))
				track.check_track_identifier(arguments.item(3))
				if track.is_valid then
					syntax_valid := True
					error := False
				else
					syntax_valid := False
					error := True
					command_result := track.error_description
				end
			end

			if not error then
				-- verify location
				if not arguments.item(4).is_integer then
					if not arguments.item(4).same_as("next") and then
						not arguments.item(4).same_as("prev") then
						syntax_valid := False
						error := True
						!!command_result.copy("Invalid get directive '")
						command_result.append(arguments.item(4))
						command_result.append("'")
					end
				else
					time := arguments.item(4).to_integer
					if time < 0 then
						syntax_valid := False
						error := True
						!!command_result.copy("Time values must be positive")
					end
				end
			end
		end

	execute is
			-- execute command
		local
			song: SONG
			track_id: TRACK_NUMBER
			track: TRACK
			i, time: INTEGER
			printable: BOOLEAN
			group: COINCIDENT_EVENTS
			multi_events: ARRAY[STRING]
			tcl_list: TCL_LIST
		do
			song := context.song_table.get(arguments.item(2))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(song)
			track_id.set_track_identifier(arguments.item(3))
			track := song.track(track_id.track_number)

			if track.empty then
				command_result := "EOT"
			else
				if arguments.item(4).is_integer then
					time := arguments.item(4).to_integer
					track.goto(time)

					if track.after then
						command_result := "EOT"
					else
						-- return all events at this time
						!!multi_events.make(1, 1)
						group := track.group
						from
							group.start
							i := 1
						until
							group.after
						loop
							if group.item.syntax.is_printable(group.item) then
								multi_events.force(group.item.syntax.format(
									track.time, group.item), i)
								i := i + 1
							end

							group.forth
						end

						!!tcl_list.make_from_split(context.tcl_interp,
							multi_events)
						tcl_list.merge

						command_result := tcl_list.list
					end
				else
					if arguments.item(4).same_as("next") then
						if track.after then
							track.start
							track.back
						end

						from
							printable := False
						until
							track.after or else printable
						loop
							track.forth
							if not track.after then
								printable := track.item.syntax.is_printable(
									track.item)
							end
						end
					elseif arguments.item(4).same_as("prev") then
						if track.before then
							track.finish
							track.forth
						end

						from
							printable := False
						until
							track.before or else printable
						loop
							track.back
							if not track.before then
								printable := track.item.syntax.is_printable(
									track.item)
							end
						end
					end

					if track.before or else track.after then
						command_result := "EOT"
					else
							-- we're either printable or off an end
							check printable end
						command_result := track.item.syntax.format(track.time,
							track.item)
					end
				end
			end
		end

end -- COMMAND_MIDI_GET
