class
	--
	-- The midiput command implementation
	--
	COMMAND_MIDI_PUT

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midiput"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID track event")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
			time: INTEGER
		do
			if arguments.count /= 4 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end

			if not error then
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				end
			end
	
			if not error then
				-- verify valid track number
				!!track.make
				track.set_context(context)
				track.set_song(context.song_table.get(arguments.item(2)))
				track.check_track_identifier(arguments.item(3))
				if track.is_valid then
					syntax_valid := True
					error := False
				else
					syntax_valid := False
					error := True
					command_result := track.error_description
				end
			end

			-- verifying event involves parsing it.  Wait for execution.

		end

	execute is
			-- execute command
		local
			song: SONG
			track_id: TRACK_NUMBER
			track: TRACK
			time, duration: INTEGER
			e: EVENT
			note_on: NOTE_ON_EVENT
			note_off: NOTE_OFF_EVENT
			tcl_list: TCL_LIST
			args: ARRAY[STRING]
		do
			song := context.song_table.get(arguments.item(2))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(song)
			track_id.set_track_identifier(arguments.item(3))
			track := song.track(track_id.track_number)

			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(4))
			tcl_list.split
			if tcl_list.error then
				error := True
			else
				args := tcl_list.split_list

				context.event_factory.set_event_description(args)
				e := context.event_factory.create_event

				if context.event_factory.error then
					command_result := context.event_factory.error_description
					error := True
				else
					if not args.item(1).is_integer then
						error := True
						!!command_result.copy("Invalid time value '")
						command_result.append(args.item(1))
						command_result.append("'")
					else
						time := args.item(1).to_integer

						-- special handling for Note events
						if args.item(2).is_equal("Note") and then
							not e.wildcard then
							note_on ?= e
								-- must be note on because of event type
								check note_on /= Void end

							if not args.item(6).is_integer then
								error := True
								!!command_result.copy("Invalid duration '")
								command_result.append(args.item(6))
								command_result.append("'")
							else
								duration := args.item(6).to_integer
								!!note_off.make
								context.annotator.annotate_event(note_off)
								note_off.set_channel(note_on.channel)
								note_off.set_pitch(note_on.pitch)
								note_off.set_velocity(0)
								note_off.set_sibling(note_on)
								note_on.set_sibling(note_off)
								track.add(note_off, time + duration)
							end
						end

						if e.wildcard then
							error := True
							command_result := "Cannot add wildcard events %
								%to track"
						else
							track.add(e, time)
						end
					end
				end
			end
		end

end -- COMMAND_MIDI_PUT
