class
	--
	-- The midiread command implementation
	--
	COMMAND_MIDI_READ

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midiread"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" FileID")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			input_chan: TCL_INPUT_CHANNEL
		do
			if arguments.count /= 2 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			else
				!!input_chan.make(context.tcl_interp, arguments.item(2))
				if not input_chan.is_connected then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid FileID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				else
					syntax_valid := True
					error := False
				end
			end
		end

	execute is
			-- execute command
		local
			input_chan: TCL_INPUT_CHANNEL
			smf: SMF_READ
			song: SONG
			song_key: STRING
			i: INTEGER
		do
			!!input_chan.make(context.tcl_interp, arguments.item(2))
			if input_chan.end_of_input then
				error := True
				!!command_result.copy("FileId at end of input")
			else
				!!smf.make_with_stream(input_chan)
				smf.read_song
				if smf.error then
					error := True
					!!command_result.copy(smf.error_description.text)
				else
					annotate_song(smf.last_song)

					-- leave song in "rewound" state
					from
						i := 1
					until
						i > smf.last_song.number_of_tracks
					loop
						smf.last_song.track(i).start
						smf.last_song.track(i).back
						i := i + 1
					end

					song_key := context.song_table.add(smf.last_song)
					command_result := song_key
				end
			end
		ensure
			new_song: not error implies context.song_table.has(command_result)
		end

feature {NONE} -- Implementation
	annotate_song(song: SONG) is
			-- add tclmidi parsing/formatting rules to events
		require
			not_void: song /= Void
		local
			i: INTEGER
		do
			from
				i := 1
			until
				i > song.number_of_tracks
			loop
				from
					song.track(i).start
				until
					song.track(i).after
				loop
					context.annotator.annotate_event(song.track(i).item)
					song.track(i).forth
				end
				i := i + 1
			end
		end

end -- COMMAND_MIDI_READ
