class
	--
	-- The midisplit command implementation
	--
	COMMAND_MIDI_SPLIT

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "midisplit"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" {SrcSongID SrcTrack} {MetaSongID MetaTrack} %
				%{OtherSongId OtherTrack}")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
			arg: INTEGER
			tcl_list: TCL_LIST
		do
			if arguments.count /= 4 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			end

			-- verify each song/track pair
			from
				arg := 2
			until
				arg > arguments.count or else error
			loop
				!!tcl_list.make_from_list(context.tcl_interp,
					arguments.item(arg))
				tcl_list.split
				if tcl_list.error then
					error := True
				end

				if not error then
					if tcl_list.split_list.count /= 2 then
						error := True
						syntax_valid := False
						!!command_result.copy("Invalid Song/Track %
							%identifier '")
						command_result.append(arguments.item(arg))
						command_result.append("'")
					end
				end

				if not error then
					if not context.song_table.has(
						tcl_list.split_list.item(1)) then
						syntax_valid := False
						error := True
						!!command_result.copy("invalid SongID '")
						command_result.append(tcl_list.split_list.item(1))
						command_result.append("'")
					end
				end

				if not error then
					-- verify valid track number
					!!track.make
					track.set_context(context)
					track.set_song(context.song_table.get(
						tcl_list.split_list.item(1)))
					track.check_track_identifier(tcl_list.split_list.item(2))
					if track.is_valid then
					syntax_valid := True
						error := False
					else
						syntax_valid := False
						error := True
						command_result := track.error_description
					end
				end

				arg := arg + 1
			end
		end

	execute is
			-- execute command
		local
			src_song, meta_song, other_song: SONG
			src_track, meta_track, other_track: TRACK
			tcl_list: TCL_LIST
			track_id: TRACK_NUMBER
			arg: INTEGER
			e, e_dup: EVENT
			meta_event: META_EVENT
			note_event, on_dup, off_dup: NOTE_EVENT
			eot_event: META_END_OF_TRACK_EVENT
		do
			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(2))
			tcl_list.split

			src_song := context.song_table.get(tcl_list.split_list.item(1))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(src_song)
			track_id.set_track_identifier(tcl_list.split_list.item(2))
			src_track := src_song.track(track_id.track_number)


			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(3))
			tcl_list.split

			meta_song := context.song_table.get(tcl_list.split_list.item(1))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(meta_song)
			track_id.set_track_identifier(tcl_list.split_list.item(2))
			meta_track := meta_song.track(track_id.track_number)


			!!tcl_list.make_from_list(context.tcl_interp, arguments.item(4))
			tcl_list.split

			other_song := context.song_table.get(tcl_list.split_list.item(1))
			!!track_id.make
			track_id.set_context(context)
			track_id.set_song(other_song)
			track_id.set_track_identifier(tcl_list.split_list.item(2))
			other_track := other_song.track(track_id.track_number)

			from
				src_track.start
			until
				src_track.after
			loop
				e := src_track.item
				eot_event ?= e
				meta_event ?= e
				note_event ?= e

				if eot_event /= Void then
					-- EOT events go in both tracks
					e_dup := e.duplicate
					meta_track.add(e_dup, src_track.time)
					e_dup := e.duplicate
					other_track.add(e_dup, src_track.time)
				elseif meta_event /= Void then
					-- meta events go into meta track
					e_dup := e.duplicate
					meta_track.add(e_dup, src_track.time)
				elseif note_event /= Void then
					-- we need to copy NoteOn/NoteOff pairs as pairs
					if not note_event.is_note_off then
						on_dup := note_event.duplicate
						if note_event.sibling /= Void then
							off_dup := note_event.sibling.duplicate
							off_dup.set_sibling(on_dup)
							on_dup.set_sibling(off_dup)
							other_track.add(off_dup, src_track.time +
							    note_event.duration)
						end
						other_track.add(on_dup, src_track.time)
					elseif note_event.sibling = Void then
						-- Only copy 'only child' NoteOff events.  If they
						-- have a sibling, then we already copied it when
						-- we encountered the NoteOn event half.
						off_dup := note_event.duplicate
						other_track.add(off_dup, src_track.time)
					end
				else
					-- all other events go in other track
					e_dup := e.duplicate
					other_track.add(e_dup, src_track.time)
				end

				src_track.forth
			end
		end

end -- COMMAND_MIDI_SPLIT
