class
	--
	-- The miditrack command implementation
	--
	COMMAND_MIDI_TRACK

inherit
	TCLMIDI_COMMAND

creation
	make

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- command name
		do
			Result := "miditrack"
		end

	usage: STRING is
			-- command syntax
		once
			!!Result.copy(command_name)
			Result.append(" SongID track {start|end}")
		end

feature -- Actions
	check_syntax is
			-- check for valid arguments
		local
			track: TRACK_NUMBER
		do
			if arguments.count /= 4 then
				syntax_valid := False
				error := True
				!!command_result.copy("wrong # args: should be %"")
				command_result.append(usage)
				command_result.append("%"")
			else
				if not context.song_table.has(arguments.item(2)) then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid SongID '")
					command_result.append(arguments.item(2))
					command_result.append("'")
				end
			end

			if not error then
				-- verify valid track number
				!!track.make
				track.set_context(context)
				track.set_song(context.song_table.get(arguments.item(2)))
				track.check_track_identifier(arguments.item(3))
				if track.is_valid then
					syntax_valid := True
					error := False
				else
					syntax_valid := False
					error := True
					command_result := track.error_description
				end
			end

			if not error then
				if not arguments.item(4).same_as("start") and then
					not arguments.item(4).same_as("end") then
					syntax_valid := False
					error := True
					!!command_result.copy("invalid track position '")
					command_result.append(arguments.item(4))
					command_result.append("'")
				end
			end
		end

	execute is
			-- execute command
		local
			song: SONG
			track: TRACK_NUMBER
			t: TRACK
		do
			song := context.song_table.get(arguments.item(2))
			!!track.make
			track.set_context(context)
			track.set_song(song)
			track.set_track_identifier(arguments.item(3))
			t := song.track(track.track_number)

			if arguments.item(4).same_as("start") then
				t.start
			else
				t.finish
			end

			command_result := t.time.to_string
		end

end -- COMMAND_MIDI_TRACK
