class
	--
	-- Different fields to check/modify with the midiconfig command
	--
	CONFIG_FLAGS

feature -- Access
	format: BOOLEAN
	division: BOOLEAN
	tracks: BOOLEAN

feature -- Element Change
	set_format is
			-- set format flag
		do
			format := True
		ensure
			format_set: format
		end

	clear_format is
			-- clear format flag
		do
			format := False
		ensure
			format_clear: not format
		end

	set_division is
			-- set division flag
		do
			division := True
		ensure
			division_set: division
		end

	clear_division is
			-- clear division flag
		do
			division := False
		ensure
			division_clear: not division
		end

	set_tracks is
			-- set tracks flag
		do
			tracks := True
		ensure
			tracks_set: tracks
		end

	clear_tracks is
			-- clear tracks flag
		do
			tracks := False
		ensure
			tracks_clear: not tracks
		end

	set_all is
			-- set all flags
		do
			format := True
			division := True
			tracks := True
		ensure
			all_set: format and division and tracks
		end

	clear_all is
			-- clear all flags
		do
			format := False
			division := False
			tracks := False
		ensure
			all_clear: not format and not division and not tracks
		end

end -- CONFIG_FLAGS
