class
	--
	-- Class to kick off the Eiffel version of the tclmidi commands
	--
	DISPATCHER

creation
	make

feature -- Initialization
	make(tcl_interp: POINTER) is
			-- create a command dispatcher
		do
			!!context.make(tcl_interp)
			!!command_midi_make.make
			!!command_midi_free.make
			!!command_midi_read.make
			!!command_midi_write.make
			!!command_midi_config.make
			!!command_midi_rewind.make
			!!command_midi_get.make
			!!command_midi_put.make
			!!command_midi_delete.make
			!!command_midi_merge.make
			!!command_midi_split.make
			!!command_midi_copy.make
			!!command_midi_track.make
			!!command_midi_grep.make
		end

feature -- Access
	error: BOOLEAN
	command_result: STRING
	error_as_integer: INTEGER is
			-- report error as an integer
		do
			Result := error.to_integer
		end

feature -- Compatibility
	set_compatibility_mode(c: STRING) is
			-- make commands compatible with earlier version
		do
			context.set_compatibility_mode(c)
		end

feature -- Commands
	midimake(args: ARRAY[STRING]) is
			-- midimake command
		do
			execute_command(command_midi_make, args)
		end

	midifree(args: ARRAY[STRING]) is
			-- midifree command
		do
			execute_command(command_midi_free, args)
		end

	midiread(args: ARRAY[STRING]) is
			-- midiread command
		do
			execute_command(command_midi_read, args)
		end

	midiwrite(args: ARRAY[STRING]) is
			-- midiwrite command
		do
			execute_command(command_midi_write, args)
		end

	midiconfig(args: ARRAY[STRING]) is
			-- midiconfig command
		do
			execute_command(command_midi_config, args)
		end

	midirewind(args: ARRAY[STRING]) is
			-- midirewind command
		do
			execute_command(command_midi_rewind, args)
		end

	midiget(args: ARRAY[STRING]) is
			-- midiget command
		do
			execute_command(command_midi_get, args)
		end

	midiput(args: ARRAY[STRING]) is
			-- midiput command
		do
			execute_command(command_midi_put, args)
		end

	mididelete(args: ARRAY[STRING]) is
			-- mididelete command
		do
			execute_command(command_midi_delete, args)
		end

	midimerge(args: ARRAY[STRING]) is
			-- midimerge command
		do
			execute_command(command_midi_merge, args)
		end

	midisplit(args: ARRAY[STRING]) is
			-- midisplit command
		do
			execute_command(command_midi_split, args)
		end

	midicopy(args: ARRAY[STRING]) is
			-- midicopy command
		do
			execute_command(command_midi_copy, args)
		end

	miditrack(args: ARRAY[STRING]) is
			-- miditrack command
		do
			execute_command(command_midi_track, args)
		end

	midigrep(args: ARRAY[STRING]) is
			-- midigrep command
		do
			execute_command(command_midi_grep, args)
		end

feature {DISPATCHER} -- Access
	context: COMMAND_CONTEXT

feature {DISPATCHER} -- Action
	execute_command(command: TCLMIDI_COMMAND; args: ARRAY[STRING]) is
			-- execute a tclmidi command
		require
			not_void: command /= Void
		do
			command_result := Void
			command.set_context(context)
			command.set_arguments(args)

			error := False
			command.check_syntax
			if command.syntax_valid then
				command.execute
			end

			error := command.error
			command_result := command.command_result
			command.reset
		end

feature {DISPATCHER} -- Commands
	command_midi_make: COMMAND_MIDI_MAKE
	command_midi_free: COMMAND_MIDI_FREE
	command_midi_read: COMMAND_MIDI_READ
	command_midi_write: COMMAND_MIDI_WRITE
	command_midi_config: COMMAND_MIDI_CONFIG
	command_midi_rewind: COMMAND_MIDI_REWIND
	command_midi_get: COMMAND_MIDI_GET
	command_midi_put: COMMAND_MIDI_PUT
	command_midi_delete: COMMAND_MIDI_DELETE
	command_midi_merge: COMMAND_MIDI_MERGE
	command_midi_split: COMMAND_MIDI_SPLIT
	command_midi_copy: COMMAND_MIDI_COPY
	command_midi_track: COMMAND_MIDI_TRACK
	command_midi_grep: COMMAND_MIDI_GREP

end -- DISPATCHER
