class
	--
	-- Bascially a hash tabel where the keys are unique ascii strings
	-- based on a common base string
	--
	HANDLE_TABLE[E]

creation
	make

feature -- Initialization
	make(base: STRING) is
			-- create table with keys based on kb
		require
			not_void: base /= Void
		do
			key_base := base
			!!dict.make
		end

feature -- Access
	key_base: STRING

	has(k: STRING): BOOLEAN is
			-- key is in table
		require
			not_void: k /= Void
		do
			Result := dict.has(k)
		end

	get(k: STRING): E is
			-- get item with key
		require
			not_void: k /= Void
			exists: has(k)
		do
			Result := dict.at(k)
		end

feature -- Element Change
	add(e: E): STRING is
			-- Add a thing to the table, return the key for it
		do
			!!Result.copy(key_base)
			Result.append(current_index.to_string)

			-- next key will have a new integer value
			current_index := current_index + 1

			dict.put(e, Result)
		ensure
			index_grew: current_index = old current_index + 1
			item_added: e = get(Result)
		end

	replace(e: E; k: STRING) is
			-- replace the item with new item
		require
			not_void: k /= Void
			exists: has(k)
		do
			dict.put(e, k)
		ensure
			replaced: e = at(k)
		end

	remove(k: STRING) is
			-- remove element with key 
		require
			not_void: k /= Void
			exists: has(k)
		do
			dict.remove(k)
		end

feature {HANDLE_TABLE} -- Implementation
	current_index: INTEGER
	dict: DICTIONARY[E, STRING]

end -- HANDLE_TABLE[E]
